/* ***************************************************************************************
* FILE:          Debug.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Debug.cpp is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#include "Debug.h"

#include <execinfo.h>
#include <stdlib.h>
#include <errno.h>

#include "ScreenBroker/ScreenBroker_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SB_SCREENBROKER //TODO: Check the default trace class. No suitable value found in (or no) macro SCREENBROKER_LOG_SET_REALM
#include "trcGenProj/Header/Debug.cpp.trc.h"
#endif


namespace ScreenBroker {
// ------------------------------------------------------------------------
//void Debug::Callstack(SCREENBROKER_LOG_REALM_TYPE realm, UInt8 maxLevels)
void Debug::Callstack(UInt8 maxLevels)
{
   if (maxLevels > 0)
   {
      int lMaxLevels = static_cast<int>(maxLevels) + 1; // ignoring current level
      void* lFunctionAddresses[lMaxLevels];
      int lLevels = backtrace(lFunctionAddresses, lMaxLevels);
      if (lLevels > 1)
      {
         ETG_TRACE_USR1_THR((  "Backtrace symbols: failed! errno=%d", errno));
         char** lFunctionCalls = backtrace_symbols(lFunctionAddresses, lLevels);
         if (0 != lFunctionCalls)
         {
            for (int i = 1; i < lLevels; ++i)
            {
               ETG_TRACE_USR1_THR((  "%40s failed! errno=%d", lFunctionCalls[i], errno));
            }
            ETG_TRACE_USR1_THR((  "No of levels in backtrace: %d failed! errno=%d", lLevels - 1, errno));
            free(lFunctionCalls);
         }
         else
         {
            ETG_TRACE_SYS_THR((  "%40s: Couldn't log callstack! No callstack symbols found! failed! errno=%d", __FUNCTION__, errno));
         }
      }
      else
      {
         ETG_TRACE_SYS_THR((  "%40s: Couldn't log callstack! No callstack levels found! failed! errno=%d", __FUNCTION__, errno));
      }
   }
   else
   {
      ETG_TRACE_SYS_THR((  "%40s: Couldn't log callstack! Invalid maxLevels (%u)! failed! errno=%d", __FUNCTION__, maxLevels, errno));
   }
}


}
