/* ***************************************************************************************
* FILE:          Types.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Types.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBroker_Types_h)
#define ScreenBroker_Types_h

#include <stdint.h>

namespace ScreenBroker {
/// @addtogroup ScreenBrokerCommon
/// @{

/**
 * @brief Char data type.
 *
 * Char data stores a single 8 bit character.
 */
typedef char Char;

/**
 * @brief Int data type.
 *
 * Int data stores signed integral data with architecture dependent bit size.
 * Int shall at least store 16 bit data.
 */
typedef signed int Int;

/** UInt data type.
    UInt data stores unsigned integral data with architecture dependent bit size.
    UInt shall at least store 16 bit data.
    The return value of the sizeof() operator (size_t) is defined as UInt. */
typedef unsigned int UInt;

/**
 * @brief Int8 data type.
 *
 * Int8 data stores signed 8 bit integral data.
 */
typedef int8_t Int8;

/**
 * @brief UInt8 data type.
 *
 * UInt8 data stores unsigned 8 bit integral data.
 */
typedef uint8_t UInt8;

/**
 * @brief Int16 data type.
 *
 * Int16 data stores signed 16 bit integral data.
 */
typedef int16_t Int16;

/**
 * @brief UInt16 data type.
 *
 * UInt16 data stores unsigned 16 bit integral data.
 */
typedef uint16_t UInt16;

/**
 * @brief Int32 data type.
 *
 * Int32 data stores signed 32 bit integral data.
 */
typedef int32_t Int32;

/**
 * @brief UInt32 data type.
 *
 * UInt32 data stores signed 32 bit integral data.
 */
typedef uint32_t UInt32;

/**
 * @brief Int64 data type.
 *
 * Int64 data stores signed 64 bit integral data.
 */
typedef int64_t Int64;

/**
 * @brief Int64 data type.
 *
 * Int64 data stores unsigned 64 bit integral data.
 */
typedef uint64_t UInt64;

/**
 * @brief Float data type.
 *
 * Float stores floating point data with 32 bits.
 */
typedef float Float;

/**
 * @brief Double data type.
 *
 * Double stores floating point data with 64 bits.
 */
typedef double Double;

/**
 * @brief Type for C/C++ bit field declarations.
 */
typedef unsigned BitField;

/**
 * @brief Maximum value for UInt.
 */
static const UInt UIntMax = static_cast<UInt>(-1);

/**
 * @brief Maximum value for UInt8.
 */
static const UInt8 UInt8Max = static_cast<UInt8>(-1);

/**
 * @brief Maximum value for UInt16.
 */
static const UInt16 UInt16Max = static_cast<UInt16>(-1);

/**
 * @brief Maximum value for UInt32.
 */
static const UInt32 UInt32Max = static_cast<UInt32>(-1);

/**
 * @brief Maximum value for UInt64.
 */
static const UInt64 UInt64Max = static_cast<UInt64>(-1);

/// @}
}


#endif
