/* ***************************************************************************************
* FILE:          ServiceRequestArg.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ServiceRequestArg.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBroker_ServiceRequestArg_h)
#define ScreenBroker_ServiceRequestArg_h

#include <ScreenBroker/RequestArg.h>
#include <string>

namespace ScreenBroker {
/// @addtogroup ScreenBrokerService
/// @{

/**
 * @brief The ServiceRequestArg struct extends the container for common request arguments with the client ID.
 * This class is forwarded in the plugins and used from the plugins for generic notifications based on
 * an incoming request e.g. run-time errors.
 */
struct ServiceRequestArg : public RequestArg
{
      ///
      ServiceRequestArg(UInt32 requestId,
                        UInt32 appId,
                        UInt32 userdata,
                        const std::string& clientId)
         : Base(requestId, appId, userdata),
           mClientId(clientId)
      {
      }

      ///
      ServiceRequestArg(const RequestArg& reqArg,
                        const std::string& clientId)
         : Base(reqArg),
           mClientId(clientId)
      {
      }

      ///
      const std::string& ClientId() const
      {
         return mClientId;
      }

   private:
      typedef RequestArg Base;
      const std::string& mClientId;

      ServiceRequestArg();
};


/// @}
}


#endif
