/* ***************************************************************************************
* FILE:          ServiceApi.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ServiceApi.cpp is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

// =============================================================================
// Using the "do { ... } while(0) construct within macros is a common practice in order
// to make the use of macros safe within conditions.
//lint -emacro({717}, CHECK_SERVICE_ADAPTOR)    "do ... while(0);"
// =============================================================================

#include "ServiceApi.h"
#include "Service.h"
#include "ServiceAdaptor.h"

#include <assert.h>
#include <ScreenBroker/Service/PluginManager.h>

using namespace ScreenBroker::Internal;

#define CHECK_SERVICE_ADAPTOR(ok)                                                               \
    do {                                                                                        \
        if (ok) {                                                                               \
            Internal::ServiceAdaptor * lAdaptor = Service::GetInstance().GetServiceAdaptor();   \
            assert(0 != lAdaptor);                                                              \
            if (0 == lAdaptor) {                                                                \
                /* not required here: ETG_TRACE_ERR(("ServiceAdaptor handle is invalid!")); */                     \
                ok = false;                                                                     \
            }                                                                                   \
        }                                                                                       \
    } while(0)
#include "ScreenBroker/ScreenBroker_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SB_SCREENBROKERSERVICE
#include "trcGenProj/Header/ServiceApi.cpp.trc.h"
#endif


namespace ScreenBroker {
// SCREENBROKER_LOG_SET_REALM(ScreenBroker::LogRealm::ScreenBrokerService);

// ------------------------------------------------------------------------
void ServiceApi::RegisterSurfaceToLayer(UInt32 surfaceId,
                                        UInt32 layerId,
                                        UInt32 userData)
{
   //SCREENBROKER_LOG_FN();
   bool ok = true;
   CHECK_SERVICE_ADAPTOR(ok);
   if (!ok)
   {
      ETG_TRACE_ERR(("ServiceAdaptor handle is invalid!"));
   }
   if (ok)
   {
      Service::GetInstance().GetServiceAdaptor()->RegisterSurfaceToLayer(surfaceId,
            layerId,
            userData);
   }
}


// ------------------------------------------------------------------------
void ServiceApi::NotifySurfaceStateChange(UInt32 userData,
      UInt32 surfaceId,
      SurfaceState::Enum surfaceState)
{
   //SCREENBROKER_LOG_FN();
   bool ok = true;
   CHECK_SERVICE_ADAPTOR(ok);
   if (!ok)
   {
      ETG_TRACE_ERR(("ServiceAdaptor handle is invalid!"));
   }
   if (ok)
   {
      Service::GetInstance().GetServiceAdaptor()->NotifySurfaceStateChange(userData,
            surfaceId,
            surfaceState);
   }
}


// ------------------------------------------------------------------------
void ServiceApi::NotifyError(const ServiceRequestArg& serviceRequestArg,
                             Int32 systemErrno,
                             Int32 presentationErrno)
{
   //SCREENBROKER_LOG_FN();
   bool ok = true;
   CHECK_SERVICE_ADAPTOR(ok);
   if (!ok)
   {
      ETG_TRACE_ERR(("ServiceAdaptor handle is invalid!"));
   }
   if (ok)
   {
      Service::GetInstance().GetServiceAdaptor()->NotifyError(serviceRequestArg,
            systemErrno,
            presentationErrno);
   }
}


// ------------------------------------------------------------------------
void ServiceApi::NotifyKeyEvent(UInt32 userData,
                                UInt32 surfaceId,
                                UInt32 keyCode,
                                KeyState::Enum keyState)
{
   //SCREENBROKER_LOG_FN();
   bool ok = true;
   CHECK_SERVICE_ADAPTOR(ok);
   if (!ok)
   {
      ETG_TRACE_ERR(("ServiceAdaptor handle is invalid!"));
   }
   if (ok)
   {
      Service::GetInstance().GetServiceAdaptor()->NotifyKeyEvent(userData,
            surfaceId,
            keyCode,
            keyState);
   }
}


// ------------------------------------------------------------------------
void ServiceApi::NotifyCurrentStatus(UInt32 requestId,
                                     UInt32 surfaceId,
                                     UInt32 status,
                                     UInt32 userData)
{
   //SCREENBROKER_LOG_FN();
   bool ok = true;
   CHECK_SERVICE_ADAPTOR(ok);
   if (!ok)
   {
      ETG_TRACE_ERR(("ServiceAdaptor handle is invalid!"));
   }
   if (ok)
   {
      Service::GetInstance().GetServiceAdaptor()->NotifyCurrentStatus(requestId,
            surfaceId,
            status,
            userData);
   }
}


// ------------------------------------------------------------------------
void ServiceApi::NotifyLayerStateChanged(UInt32 requestId,
      UInt32 layerId,
      LayerState::Enum layerstate)
{
   //SCREENBROKER_LOG_FN();
   bool ok = true;
   CHECK_SERVICE_ADAPTOR(ok);
   if (!ok)
   {
      ETG_TRACE_ERR(("ServiceAdaptor handle is invalid!"));
   }
   if (ok)
   {
      Service::GetInstance().GetServiceAdaptor()->NotifyLayerStateChanged(requestId,
            layerId,
            layerstate);
   }
}


// ------------------------------------------------------------------------
void ServiceApi::NotifyCloseOnExternalTouch(bool status)
{
   //SCREENBROKER_LOG_FN();
   bool ok = true;
   CHECK_SERVICE_ADAPTOR(ok);
   if (!ok)
   {
      ETG_TRACE_ERR(("ServiceAdaptor handle is invalid!"));
   }
   if (ok)
   {
      Service::GetInstance().GetServiceAdaptor()->NotifyCloseOnExternalTouch(status);
   }
}


// ------------------------------------------------------------------------
void ServiceApi::AddBuildInLayerInformation(UInt32 layerId, UInt32 surfaceId, UInt32 screenId, UInt32 width, UInt32 height, std::string connectorName)
{
   //SCREENBROKER_LOG_FN();
   bool ok = true;
   CHECK_SERVICE_ADAPTOR(ok);
   if (!ok)
   {
      ETG_TRACE_ERR(("ServiceAdaptor handle is invalid!"));
   }
   if (ok)
   {
      Service::GetInstance().GetServiceAdaptor()->UpdateBuildInLayerInformation(layerId, surfaceId, screenId, width, height, connectorName);
   }
}


// ------------------------------------------------------------------------
IKeyHandler* ServiceApi::KeyHandler()
{
   return Internal::PluginManager::GetInstance().Plugin<IKeyHandler>();
}


// ------------------------------------------------------------------------
IPopupManagerActivator* ServiceApi::PopupManagerActivator()
{
   return Internal::PluginManager::GetInstance().Plugin<IPopupManagerActivator>();
}


// ------------------------------------------------------------------------
IScreenBrokerActivator* ServiceApi::ScreenBrokerActivator()
{
   return Internal::PluginManager::GetInstance().Plugin<IScreenBrokerActivator>();
}


// ------------------------------------------------------------------------
IScreenLayouter* ServiceApi::ScreenLayouter()
{
   return Internal::PluginManager::GetInstance().Plugin<IScreenLayouter>();
}


// ------------------------------------------------------------------------
IConfigurator* ServiceApi::Configurator()
{
   return Internal::PluginManager::GetInstance().Plugin<IConfigurator>();
}


// ------------------------------------------------------------------------
bool ServiceApi::HasIlmAccess()
{
   return Service::GetInstance().HasIlmAccess();
}


}
