/* ***************************************************************************************
* FILE:          ScreenBrokerService.h
* SW-COMPONENT:  HMI-BASE
* DESCRIPTION:  ScreenBrokerService.h is part of HMI-Base ScreenBroker
* COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef ScreenBrokerService_h
#define ScreenBrokerService_h

#include "asf/core/BaseComponent.h"
#include <ScreenBroker/Version.h>
#include <ScreenBroker/Service/LayerManagerAccessor.h>
#include <ScreenBroker/Service/Service.h>

#include <iostream>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sstream>


namespace ScreenBroker {
namespace Service {


class ScreenBrokerService : public asf::core::BaseComponent
{
   public:
      ScreenBrokerService();
      virtual ~ScreenBrokerService();

      void static OnTermination(int sig, siginfo_t* siginfo, void* context);
      void static OnReset(int sig, siginfo_t* siginfo, void* context);
      void static OnDiagnosis(int sig, siginfo_t* siginfo, void* context);

   private:
      int vHandleSysSignals();
};


} //namespace
}


#endif
