/* ***************************************************************************************
* FILE:          PopupState.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PopupState.cpp is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#include "PopupState.h"

#include <ScreenBroker/Util/Time.h>
#include <sys/time.h>
#include "ScreenBroker/ScreenBroker_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SB_SCREENBROKERSERVICE
#include "trcGenProj/Header/PopupState.cpp.trc.h"
#endif


namespace ScreenBroker {
// SCREENBROKER_LOG_SET_REALM(LogRealm::PopupManager);

// ------------------------------------------------------------------------
PopupState::PopupState(UInt32 surfaceId)
   : mSurfaceId(surfaceId),
     mPopupScreenAreaId(0),
     mLayerId(0),
     mUserData(0),
     mAppId(0),
     mRequestId(0),
     mVisible(false),
     mNextUpdatePeriod(0),
     mNextUpdateTimeBase(0)
{
}


// ------------------------------------------------------------------------
PopupState::~PopupState()
{
}


// ------------------------------------------------------------------------
void PopupState::SetNextUpdatePeriod(UInt32 nextUpdatePeriod)
{
   mNextUpdateTimeBase = Time::Now();
   mNextUpdatePeriod = 0ul;

   // Retrieve new time base
   if (0ull != mNextUpdateTimeBase)
   {
      mNextUpdatePeriod = nextUpdatePeriod;
      ETG_TRACE_USR1(("Next update time for popup with surface ID:%u set to %u (base) + %ums(period)",
                      mSurfaceId,
                      mNextUpdateTimeBase,
                      mNextUpdatePeriod));
   }
   else
   {
      ETG_TRACE_ERR(("Setting next update time base for popup with surface ID:%u failed!",
                     mSurfaceId));
   }
}


// ------------------------------------------------------------------------
void PopupState::ApplyProperties(UInt32 popupScreenAreaId,
                                 UInt32 layerId,
                                 const PopupPresentationArg& popupPresentationArg,
                                 const RequestArg& requestArg)
{
   mPopupScreenAreaId = popupScreenAreaId;
   mLayerId = layerId;
   mPopupPresentationArg = popupPresentationArg;
   mAppId = requestArg.AppId();
   mUserData = requestArg.UserData();
   mRequestId = requestArg.RequestId();
}


}
