/* ***************************************************************************************
* FILE:          Screenbroker.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Screenbroker.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBroker_ScreenBroker_h)
#define ScreenBroker_ScreenBroker_h

// =============================================================================
// Standard C/C++ header issues are out of scope of screenbroker.
//lint -efile(451, stdio.h, stdarg.h)   "Header file repeatedly included but does not have a standard include guard"
// All function-calls in destructor, like logging, std-c++ container class access or
// layer manager accessor functions are guaranteed to not throw an exception.
//lint -efunc(1551, ScreenBroker::[*::]~*)  "Function may throw exception '...' in destructor"
// =============================================================================

#include <ScreenBroker/Types.h>
#include <ScreenBroker/Config.h>
#include <ScreenBroker/Version.h>

// Central place for forward declarations of internal classes
namespace ScreenBroker {
namespace Internal {
class ClientState;
class PopupArea;
class ServiceAdaptor;
class ServiceProxy;
}


}

// Macros to avoid variable/parameter unused warnings
#define SCREENBROKER_UNUSED(a)              (void) a
#define SCREENBROKER_UNUSED2(a, b)          SCREENBROKER_UNUSED(a); (void) b
#define SCREENBROKER_UNUSED3(a, b, c)       SCREENBROKER_UNUSED2(a, b); (void) c
#define SCREENBROKER_UNUSED4(a, b, c, d)    SCREENBROKER_UNUSED3(a, b, c); (void) d
#define SCREENBROKER_UNUSED5(a, b, c, d, e) SCREENBROKER_UNUSED4(a, b, c, d); (void) e

/**
 * @mainpage  Screen broker and popup manager
 *
 * <b><em>Introduction</em></b>
 * <p>
 * The <b>screen broker</b> and <b>popup manager</b> are intended for HMI integrated into
 * environments containing components defined by Genivi, especially IVI Layer Manager (ILM)
 * as well as display client/server architecture built on Wayland or similar components.
 * </p>
 * <br/>
 * <p>
 * For more details about <b>Screen Broker</b> and <b>Popup Manager</b> requirements, concept
 * and use cases please refer to the concept paper
 * (<a href="../../doc/Design_ScreenBroker_and_PopupManager.pdf">Design_ScreenBroker_and_PopupManager.pdf</a>).
 * </p>
 *
 * ------------------------------------------------------------------------
 * COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 */

/**
 * @defgroup ScreenBroker Screen broker
 */

/**
 * @defgroup ScreenBrokerClientDev Screen broker client development
 * @brief List all the interfaces exposed to client application development.
 *
 * These defines are basically set via Courier features and platform when
 * running the CMake build system.
 * @ingroup ScreenBroker
 */

/**
 * @defgroup ScreenBrokerPluginDev Screen broker plugin development
 * @brief List all the interfaces exposed to server side plugin development.
 * @ingroup ScreenBroker
 */

/**
 * @defgroup ScreenBrokerClient Client programming interface
 * @ingroup ScreenBrokerClientDev
 */

/**
 * @defgroup ScreenBrokerCommon Common definitions and classes
 * @ingroup ScreenBrokerClientDev
 * @ingroup ScreenBrokerPluginDev
 */

/**
 * @defgroup ScreenBrokerPlugin Plugin development interfaces
 * @ingroup ScreenBrokerPluginDev
 */

/**
 * @defgroup ScreenBrokerService Public screen broker server interfaces
 * @ingroup ScreenBrokerPluginDev
 */

/**
 * @defgroup PopupManager Public popup manager server interfaces
 * @ingroup ScreenBrokerService
 */

/**
 * @defgroup ScreenBrokerUtil Utility functions and classes
 * @ingroup ScreenBrokerClientDev
 * @ingroup ScreenBrokerPluginDev
 */


#endif
