/* ***************************************************************************************
* FILE:          RequestArg.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RequestArg.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBroker_RequestArg_h)
#define ScreenBroker_RequestArg_h

#include <ScreenBroker/ScreenBroker.h>

namespace ScreenBroker {
/// @addtogroup ScreenBrokerCommon
/// @{

/**
 * @brief The RequestArg struct serves as container for common request arguments.
 */
struct RequestArg
{
      RequestArg()
         : mRequestId(0),
           mAppId(0),
           mUserData(0)
      {
      }

      ///
      RequestArg(UInt32 requestId,
                 UInt32 appId,
                 UInt32 userdata)
         : mRequestId(requestId),
           mAppId(appId),
           mUserData(userdata)
      {
      }

      ///
      UInt32 RequestId() const
      {
         return mRequestId;
      }

      ///
      UInt32 AppId() const
      {
         return mAppId;
      }

      ///
      UInt32 UserData() const
      {
         return mUserData;
      }

   private:
      UInt32 mRequestId;
      UInt32 mAppId;
      UInt32 mUserData;
};


/// @}
}


#endif
