/* ***************************************************************************************
* FILE:          Config.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Config.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBroker_Config_h)
#define ScreenBroker_Config_h

/// @addtogroup ScreenBrokerCommon
/// @{

/// Activates logging via DLT (see http://projects.genivi.org/diagnostic-log-trace/home)
#define SCREENBROKER_WITH_DLT

/// Activates systemd notification
#define SCREENBROKER_WITH_SYSTEMD
/// Activates the thread synchronization interface on client side
#define SCREENBROKER_WITH_CLIENTSYNC

/// Activates the scope logging applied in various client and server code (mostly applied in communication interfaces)
/* #undef SCREENBROKER_WITH_SCOPELOGGING */

/// Defines the DBUS binding library
#define SCREENBROKER_DBUS_BINDING GDBUS

/// Define for GDBUS dbus binding
#define SCREENBROKER_DBUS_BINDING_GDBUS

/// Define for dbus-c++ dbus binding
/* #undef SCREENBROKER_DBUS_BINDING_DBUS_CXX */

/// Define for version value of layer manager
#define LAYERMANAGER_VERSION 1_1

/// Define for layer manager version 1_1
#define LAYERMANAGER_VERSION_1_1

/// Define for Screen Broker Plugin dynamic loading
/// For static loading SCREENBROKER_DYNAMIC_PLUGIN need not be defined.
//#define SCREENBROKER_DYNAMIC_PLUGIN

/// @}

#endif
