/* ***************************************************************************************
* FILE:          ServiceProxy.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ServiceProxy.cpp is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#include "ServiceProxy.h"
#include "Client.h"
#include <ScreenBroker/DimensionArg.h>
#include <ScreenBroker/Client/ASF/AsfServiceProxy.h>


#include "ScreenBroker/ScreenBroker_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SB_SCREENBROKERCLIENT
#include "trcGenProj/Header/ServiceProxy.cpp.trc.h"
#endif


namespace ScreenBroker {
namespace Internal {
// SCREENBROKER_LOG_SET_REALM(ScreenBroker::LogRealm::ScreenBrokerClient);

// ------------------------------------------------------------------------
ServiceProxy* ServiceProxy::Create(ClientApi* clientApi, std::string& clientId, ::asf::core::BaseComponent* baseComponent)
{
   return AsfServiceProxy::DoCreate(clientApi, clientId, baseComponent);
}


// ------------------------------------------------------------------------
ServiceProxy::~ServiceProxy()
{
   mClientApi = 0;
}


// ------------------------------------------------------------------------
ServiceProxy::ServiceProxy(ClientApi* clientApi) :
   mClientApi(clientApi)
{
}


// ------------------------------------------------------------------------
ClientApi* ServiceProxy::SetClientApi(ClientApi* clientApi)
{
   //SCREENBROKER_LOG_FN();
   Api api(this);
   mClientApi = clientApi;
   return *api;
}


// ------------------------------------------------------------------------
void ServiceProxy::Init()
{
   //SCREENBROKER_LOG_FN();
   DoInit();
}


// ------------------------------------------------------------------------
void ServiceProxy::Run()
{
   //SCREENBROKER_LOG_FN();
   DoRun();
}


// ------------------------------------------------------------------------
void ServiceProxy::Synchronize()
{
   //SCREENBROKER_LOG_FN();
#if defined(SCREENBROKER_WITH_CLIENTSYNC)
   // Wait until "run" thread is on track
   if (-1 == _cond.wait(0xFFFFFFFF))
   {
      ETG_TRACE_ERR_THR(("Wait for run synchronization failed! errno=%d", errno));
   }
#endif
}


// ------------------------------------------------------------------------
void ServiceProxy::Terminate()
{
   //SCREENBROKER_LOG_FN();
   DoTerminate();
}


}
}
