/* ***************************************************************************************
* FILE:          ClientUtil.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ClientUtil.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBroker_Client_ClientUtil_h)
#define ScreenBroker_Client_ClientUtil_h

#include <ScreenBroker/ScreenBroker.h>

namespace ScreenBroker {
/// @addtogroup ScreenBrokerClient
/// @{

/**
 * @brief The ClientUtil class provides some useful utility function for screen broker client usage.
 */
class ClientUtil
{
   public:
      /**
       * @brief Simple generator for sequential request IDs.
       *
       * @returns Next available request ID.
       */
      static UInt32 GenerateRequestId();
};


/// @}
}


#endif
