/* ***************************************************************************************
* FILE:          ToggleInvalidation.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ToggleInvalidation.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "ToggleInvalidation.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::ToggleInvalidation::
#include "trcGenProj/Header/ToggleInvalidation.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

ToggleInvalidation& ToggleInvalidation::GetInstance()
{
   static ToggleInvalidation theInstance;
   return theInstance;
}


ToggleInvalidation::ToggleInvalidation()
{
   ETG_I_REGISTER_FILE();
}


ToggleInvalidation::~ToggleInvalidation()
{
   ETG_I_UNREGISTER_FILE();
}


void ToggleInvalidation::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< ToggleInvalidationPayload > >& payload)
{
   if (_stub)
   {
      std::vector<int> pids;
      if (_stub->getClientsPid(payload->get0(), pids))
      {
         for (std::vector<int>::iterator it = pids.begin(); it != pids.end(); ++it)
         {
            _stub->sendTraceQuerySignal(TraceQueryData(*it, traceQueryId__TOGGLE_INVALIDATION, std::vector< ::std::string >()));
         }
      }
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "Toggle_Invalidation %s", ETG_I_STRING))
void ToggleInvalidation::TraceCommand(const char* appName)
{
   if (GetInstance()._stub)
   {
      ToggleInvalidationPayload payload = appName;
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
