/* ***************************************************************************************
* FILE:          StartAnimation.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  StartAnimation.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "StartAnimation.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>
#include "SurfaceGeometryHelper.h"
#include "SurfaceGeometryHelper.h"
#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"
#include "iostream"

using namespace bosch::cm::ai::hmi::appctrl::trace::Commands;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::StartAnimation::
#include "trcGenProj/Header/StartAnimation.cpp.trc.h"
#endif

namespace hmibase {
namespace trace {
namespace command {

StartAnimation& StartAnimation::GetInstance()
{
   static StartAnimation theInstance;
   return theInstance;
}


StartAnimation::StartAnimation()
{
   ETG_I_REGISTER_FILE();
}


StartAnimation::~StartAnimation()
{
   ETG_I_UNREGISTER_FILE();
}


void StartAnimation::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< StartAnimationPayload > >& payload)
{
   if (_stub)
   {
      std::vector<std::string> animationData;
      std::vector<SurfaceGeometryHelper::surfaceTouchGeometry> v;
      SurfaceGeometryHelper surfaceGeometryHelper;

      if (surfaceGeometryHelper.getSurfaceCluster(v))
      {
         int pid = surfaceGeometryHelper.getPidForSurfaceId(payload->get0().surfaceId);
         if (pid != 0)
         {
            std::stringstream str, str1;
            str << payload->get0().surfaceId;
            animationData.push_back(str.str());
            str1 << payload->get0().animationType;
            animationData.push_back(str1.str());
            _stub->sendTraceQuerySignal(TraceQueryData(pid, traceQueryId__SB_START_ANIMATION, animationData));
         }
      }
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "SB_StartAnimation %d %d", unsigned int, unsigned int))
void StartAnimation::TraceCommand(unsigned int surfaceId, unsigned int animationType)
{
   if (GetInstance()._stub)
   {
      StartAnimationPayload payload(surfaceId, animationType);
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
