/* ***************************************************************************************
* FILE:          SimTouchByText.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SimTouchByText.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "SimTouchByText.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>
#include "SurfaceGeometryHelper.h"

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::SimTouchByText::
#include "trcGenProj/Header/SimTouchByText.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

SimTouchByText& SimTouchByText::GetInstance()
{
   static SimTouchByText theInstance;
   return theInstance;
}


SimTouchByText::SimTouchByText()
{
   ETG_I_REGISTER_FILE();
}


SimTouchByText::~SimTouchByText()
{
   ETG_I_UNREGISTER_FILE();
}


void SimTouchByText::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SimTouchByTextPayload > >& payload)
{
   if (_stub)
   {
      std::vector<SurfaceGeometryHelper::surfaceTouchGeometry> v;
      SurfaceGeometryHelper surfaceGeometryHelper;
      std::vector<int> pids; //unique pid vector
      pids.push_back(0); //default initialization

      if (surfaceGeometryHelper.getSurfaceCluster(v))
      {
         std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo > touchableSurfaces;
         for (std::vector<SurfaceGeometryHelper::surfaceTouchGeometry>::iterator it = v.begin(); it != v.end(); ++it)
         {
            int pid = surfaceGeometryHelper.getPidForSurfaceId(it->surfaceId);
            if ((pid != 0) && (std::find(pids.begin(), pids.end(), pid) == pids.end())) //to retrieve only unique pids
            {
               pids.push_back(pid);
            }
            ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo surfaceInfo;
            ::bosch::cm::ai::hmi::appctrl::trace::Commands::Rect rect(it->touchableRect.ptMin.x,
                  it->touchableRect.ptMin.y ,
                  it->touchableRect.getWidth(),
                  it->touchableRect.getHeight());
            surfaceInfo.setSurfaceId(it->surfaceId);
            surfaceInfo.setRect(rect);
            touchableSurfaces.push_back(surfaceInfo);
         }
         if (pids.size() > 0)
         {
            for (std::vector<int>::iterator it = pids.begin(); it != pids.end(); ++it)
            {
               _stub->sendSimTouchByTextSignal(SimTouchByTextData(*it, touchableSurfaces, payload->get0()));
            }
         }
         else
         {
            ETG_TRACE_FATAL(("SimTouch: no pid for surface registered"));
         }
      }
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "SimTouchByText %s", ETG_I_STRING))
void SimTouchByText::TraceCommand(const char* text)
{
   if (GetInstance()._stub)
   {
      SimTouchByTextPayload payload = text;
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
