/* ***************************************************************************************
* FILE:          SimTouchByIndex.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SimTouchByIndex.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "SimTouchByIndex.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>
#include "SurfaceGeometryHelper.h"

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::SimTouchByIndex::
#include "trcGenProj/Header/SimTouchByIndex.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

SimTouchByIndex& SimTouchByIndex::GetInstance()
{
   static SimTouchByIndex theInstance;
   return theInstance;
}


SimTouchByIndex::SimTouchByIndex()
{
   ETG_I_REGISTER_FILE();
}


SimTouchByIndex::~SimTouchByIndex()
{
   ETG_I_UNREGISTER_FILE();
}


void SimTouchByIndex::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SimTouchByIndexPayload > >& payload)
{
   if (_stub)
   {
      std::vector<SurfaceGeometryHelper::surfaceTouchGeometry> v;
      SurfaceGeometryHelper surfaceGeometryHelper;

      if (surfaceGeometryHelper.getSurfaceCluster(v))
      {
         std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo > touchableSurfaces;

         // fill array to post with surface information
         for (std::vector<SurfaceGeometryHelper::surfaceTouchGeometry>::iterator it = v.begin(); it != v.end(); ++it)
         {
            ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo surfaceInfo;
            ::bosch::cm::ai::hmi::appctrl::trace::Commands::Rect rect(it->touchableRect.ptMin.x,
                  it->touchableRect.ptMin.y ,
                  it->touchableRect.getWidth(),
                  it->touchableRect.getHeight());
            surfaceInfo.setSurfaceId(it->surfaceId);
            surfaceInfo.setRect(rect);
            touchableSurfaces.push_back(surfaceInfo);
         }

         for (std::vector<SurfaceGeometryHelper::surfaceTouchGeometry>::iterator it = v.begin(); it != v.end(); ++it)
         {
            int pid = surfaceGeometryHelper.getPidForSurfaceId(it->surfaceId);

            if (pid != 0)
            {
               _stub->sendSimTouchByIndexSignal(SimTouchByIndexData(pid, touchableSurfaces, static_cast<int32>(payload->get0().listId), static_cast<int32>(payload->get0().buttonWidgetIdx)));
            }
            else
            {
               ETG_TRACE_FATAL(("SimTouch: no pid for surface %d registered", it->surfaceId));
            }
         }
      }
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "SimTouchByIndex %u %u", unsigned int, unsigned int))
void SimTouchByIndex::TraceCommand(unsigned int listId, unsigned int buttonWidgetIndex)
{
   if (GetInstance()._stub)
   {
      SimTouchByIndexPayload payload(listId, buttonWidgetIndex);
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
