/* ***************************************************************************************
* FILE:          SimTouch.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SimTouch.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "SimTouch.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>
#include "SurfaceGeometryHelper.h"

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace bosch::cm::ai::hmi::appctrl::trace::Commands;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::SimTouch::
#include "trcGenProj/Header/SimTouch.cpp.trc.h"
#endif

namespace hmibase {
namespace trace {
namespace command {

SimTouch& SimTouch::GetInstance()
{
   static SimTouch theInstance;
   return theInstance;
}


SimTouch::SimTouch()
{
   ETG_I_REGISTER_FILE();
}


SimTouch::~SimTouch()
{
   ETG_I_UNREGISTER_FILE();
}


void SimTouch::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SimTouchPayload > >& payload)
{
   if (_stub)
   {
      std::vector<SurfaceGeometryHelper::surfaceTouchGeometry> v;
      SurfaceGeometryHelper surfaceGeometryHelper;

      if (surfaceGeometryHelper.getSurfaceCluster(v))
      {
         for (std::vector<SurfaceGeometryHelper::surfaceTouchGeometry>::iterator it = v.begin(); it != v.end(); ++it)
         {
            if (it->touchableRect.contains(::hmibase::util::geometry::Point(payload->get0().xPos, payload->get0().yPos)))
            {
               int pid = surfaceGeometryHelper.getPidForSurfaceId(it->surfaceId);

               if (pid != 0)
               {
                  _stub->sendSimTouchSignal(SimTouchData(pid, payload->get0().xPos, payload->get0().yPos, it->surfaceId, 0, payload->get0().state));
               }
               else
               {
                  ETG_TRACE_FATAL(("SimTouch: no pid for surface %d registered", it->surfaceId))
               }
               break;
            }
         }
      }
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "SimTouch %d %d", unsigned short, unsigned short))
ETG_I_CMD_DEFINE((TraceCommand, "SimTouchExt %d %d %d", unsigned short, unsigned short, ETG_I_CENUM(simulatedTouchStates)))
void SimTouch::TraceCommand(unsigned short xPos, unsigned short yPos, ::bosch::cm::ai::hmi::appctrl::trace::Commands::simulatedTouchStates state)
{
   if (GetInstance()._stub)
   {
      SimTouchPayload payload(xPos, yPos, state);
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
