/* ***************************************************************************************
* FILE:          SimEnterKey.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SimEnterKey.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "SimEnterKey.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace::command;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::SimEnterKey::
#include "trcGenProj/Header/SimEnterKey.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

SimEnterKey& SimEnterKey::GetInstance()
{
   static SimEnterKey theInstance;
   return theInstance;
}


SimEnterKey::SimEnterKey()
{
   ETG_I_REGISTER_FILE();
}


SimEnterKey::~SimEnterKey()
{
   ETG_I_UNREGISTER_FILE();
}


void SimEnterKey::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SimEnterKeyPayload > >& payload)
{
   if (_stub)
   {
      std::vector<int> pids;
      if (_stub->getClientsPid(payload->get0().appName, pids))
      {
         for (std::vector<int>::iterator it = pids.begin(); it != pids.end(); ++it)
         {
            _stub->sendSimEnterKeySignal(SimEnterKeyData(*it, (unsigned int)(payload->get0().state), payload->get0().source));
         }
      }
      else
      {
         ETG_TRACE_FATAL(("SimEnterKey Unknown application '%s'", payload->get0().appName));
      }
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "SimEnterKey %50s %d %50s", ETG_I_STRING, ETG_I_CENUM(enHardKeyState), ETG_I_STRING))
void SimEnterKey::TraceCommand(const char* appName, enHardKeyState state, const char* source)
{
   if (GetInstance()._stub)
   {
      SimEnterKeyPayload payload(appName, state, source);
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
