/* ***************************************************************************************
* FILE:          SetWidgetProperty.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SetWidgetProperty.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_SETWIDGETPROPERTY_H
#define HMIBASE_TRACE_COMMAND_SETWIDGETPROPERTY_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

struct SetWidgetPropertyPayload
{
   std::string widget;
   std::string property;
   std::string propertyValue;
   std::string parent;

   SetWidgetPropertyPayload(const char* w, const char* prop, const char* propVal) : widget(w), property(prop), propertyValue(propVal)
   {
   }

   SetWidgetPropertyPayload(const char* w, const char* p, const char* prop, const char* propVal) : widget(w), property(prop), propertyValue(propVal), parent(p)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const SetWidgetPropertyPayload& payload)
   {
      os << payload.property;
      os << payload.propertyValue;
      os << payload.widget;
      os << payload.parent;
      return os;
   }
};


class SetWidgetProperty :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< SetWidgetPropertyPayload >
{
   private:

      SetWidgetProperty();

   public:
      virtual ~SetWidgetProperty();

      static SetWidgetProperty& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SetWidgetPropertyPayload > >& payload);

      static void TraceCommand(const char* parentWidgetName, const char* widgetName, const char* propertyName);
      static void TraceCommand(const char* parentWidgetName, const char* widgetName, const char* propertyName, const char* propertyValue);
};


}
}


}
#endif
