/* ***************************************************************************************
* FILE:          SceneAction.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SceneAction.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_SCENEACTION_H
#define HMIBASE_TRACE_COMMAND_SCENEACTION_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

enum enSceneAction
{
   SHOW = 1,
   HIDE
};


struct SceneActionPayload
{
   enSceneAction action;
   std::string viewName;

   SceneActionPayload(enSceneAction a, const char* vn) : action(a), viewName(vn)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const SceneActionPayload& payload)
   {
      os << payload.action;
      os << payload.viewName;
      return os;
   }
};


class SceneAction :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< SceneActionPayload >
{
   private:

      SceneAction();

   public:
      virtual ~SceneAction();

      static SceneAction& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SceneActionPayload > >& payload);

      static void TraceCommand(enSceneAction action, const char* viewname);
};


}
}


}
#endif
