/* ***************************************************************************************
* FILE:          SceneAction.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SceneAction.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "SceneAction.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace::command;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::SceneAction::
#include "trcGenProj/Header/SceneAction.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

SceneAction& SceneAction::GetInstance()
{
   static SceneAction theInstance;
   return theInstance;
}


SceneAction::SceneAction()
{
   ETG_I_REGISTER_FILE();
}


SceneAction::~SceneAction()
{
   ETG_I_UNREGISTER_FILE();
}


void SceneAction::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SceneActionPayload > >& payload)
{
   if (_stub)
   {
      std::vector < std::string> viewNameData;
      viewNameData.push_back(payload->get0().viewName);

      if (payload->get0().action == HIDE)
      {
         _stub->sendTraceQuerySignal(TraceQueryData(0, traceQueryId__HIDE_SCENE, viewNameData));
      }
      else if (payload->get0().action == SHOW)
      {
         _stub->sendTraceQuerySignal(TraceQueryData(0, traceQueryId__SHOW_SCENE, viewNameData));
      }
      else
      {
         ETG_TRACE_FATAL(("Unknown Scene Change Action"));
      }
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "SceneAction %u %100s", ETG_I_CENUM(enSceneAction), ETG_I_STRING))
void SceneAction::TraceCommand(enSceneAction action, const char* viewname)
{
   if (GetInstance()._stub)
   {
      SceneActionPayload payload(action, viewname);
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
