/* ***************************************************************************************
* FILE:          GetWidgetPropertyInfo.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GetWidgetPropertyInfo.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_GETWIDGETPROPERTYINFO_H
#define HMIBASE_TRACE_COMMAND_GETWIDGETPROPERTYINFO_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

struct GetWidgetPropertyInfoPayload
{
   std::string widget;
   std::string property;
   std::string parent;

   GetWidgetPropertyInfoPayload(const char* w, const char* prop, const char* p) : widget(w), property(prop), parent(p)
   {
   }

   GetWidgetPropertyInfoPayload(const char* w, const char* prop) : widget(w), property(prop)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const GetWidgetPropertyInfoPayload& payload)
   {
      os << payload.property;
      os << payload.widget;
      os << payload.parent;
      return os;
   }
};


class GetWidgetPropertyInfo :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< GetWidgetPropertyInfoPayload >
{
   private:

      GetWidgetPropertyInfo();

   public:
      virtual ~GetWidgetPropertyInfo();

      static GetWidgetPropertyInfo& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< GetWidgetPropertyInfoPayload > >& payload);

      static void TraceCommand(const char* widgetName, const char* propertyName);
      static void TraceCommand(const char* parentWidgetName, const char* widgetName, const char* propertyName);
};


}
}


}
#endif
