/* ***************************************************************************************
* FILE:          GetWidgetInstanceInfo.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GetWidgetInstanceInfo.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_GETWIDGETINSTANCEINFO_H
#define HMIBASE_TRACE_COMMAND_GETWIDGETINSTANCEINFO_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

struct GetWidgetInstanceInfoPayload
{
   std::string widget;
   std::string parent;

   GetWidgetInstanceInfoPayload(const char* w) : widget(w)
   {
   }

   GetWidgetInstanceInfoPayload(const char* w, const char* p) : widget(w), parent(p)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const GetWidgetInstanceInfoPayload& payload)
   {
      os << payload.parent;
      os << payload.widget;
      return os;
   }
};


class GetWidgetInstanceInfo :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< GetWidgetInstanceInfoPayload >
{
   private:

      GetWidgetInstanceInfo();

   public:
      virtual ~GetWidgetInstanceInfo();

      static GetWidgetInstanceInfo& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< GetWidgetInstanceInfoPayload > >& payload);

      static void TraceCommand(const char* widgetName);
      static void TraceCommand(const char* parentWidgetName, const char* childWidgetName);
};


}
}


}
#endif
