/* ***************************************************************************************
* FILE:          GetVisibleScreen.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GetVisibleScreen.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_GETVISIBLESCREEN_H
#define HMIBASE_TRACE_COMMAND_GETVISIBLESCREEN_H

#include "asf/core/BaseComponent.h"
#include "asf/core/Timer.h"
#include <string.h>
#include <map>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/TraceQueryResponseHandler.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {

class HMIBaseTraceCmds;

namespace command {

enum enSceneCategory
{
   ALL_SCENES,
   MAIN_SCENE_CATEGORY,
   POPUP_SCENE_CATEGORY,
   OTHER_SCENE_CATEGORY,
   MAIN_AND_POPUP_SCENE_CATEGORIES
};


struct GetVisibleScreenPayload
{
   enSceneCategory category;

   GetVisibleScreenPayload(enSceneCategory a) : category(a)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const GetVisibleScreenPayload& payload)
   {
      os << payload.category;
      return os;
   }
};


class GetVisibleScreen :
   public ::hmibase::trace::command::TraceCmdHandler,
   public asf::core::LocalMessageCallbackIF1< GetVisibleScreenPayload >,
   public ::hmibase::trace::TraceQueryResponseHandler,
   public asf::core::TimerCallbackIF
{
   private:

      struct visibleScreenInfo
      {
         bool mainSceneDataReceived;
         bool otherSceneDataReceived;
         bool popupSceneDataReceived;
         std::vector<std::string> mainScenes;
         std::vector<std::string> otherScenes;
         std::vector<std::string> popupScenes;

         visibleScreenInfo() : mainSceneDataReceived(false), otherSceneDataReceived(false), popupSceneDataReceived(false) {}
      };

      GetVisibleScreen();

      asf::core::Timer _timer;
      std::map<int, visibleScreenInfo> _visibleScreenData;

      enSceneCategory _currentRequest;

      void print(bool force = false);

   public:
      virtual ~GetVisibleScreen();

      static GetVisibleScreen& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< GetVisibleScreenPayload > >& payload);

      virtual void onExpired(::asf::core::Timer& timer, ::boost::shared_ptr<asf::core::TimerPayload> payload);

      virtual void Configure(HMIBaseTraceCmds* baseComponent);

      virtual bool Handle(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateTraceQueryResultRequest >& data);

      static void TraceCommand(enSceneCategory e = ALL_SCENES);
};


}
}


}
#endif
