/* ***************************************************************************************
* FILE:          GetSMInfo.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GetSMInfo.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "GetSMInfo.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::GetSMInfo::
#include "trcGenProj/Header/GetSMInfo.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

GetSMInfo& GetSMInfo::GetInstance()
{
   static GetSMInfo theInstance;
   return theInstance;
}


GetSMInfo::GetSMInfo()
{
   ETG_I_REGISTER_FILE();
}


GetSMInfo::~GetSMInfo()
{
   ETG_I_UNREGISTER_FILE();
}


void GetSMInfo::Configure(HMIBaseTraceCmds* baseComponent)
{
   TraceCmdHandler::Configure(baseComponent);

   if (_stub)
   {
      _stub->RegisterMethodHandler(this);
   }
}


void GetSMInfo::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< GetSMInfoPayload > >& payload)
{
   if (_stub)
   {
      if (payload->get0().empty())
      {
         _stub->sendTraceQuerySignal(TraceQueryData(0, traceQueryId__GET_STATEMACHINE_INFO, std::vector< ::std::string >()));
      }
      else
      {
         std::vector<int> pids;
         if (_stub->getClientsPid(payload->get0(), pids))
         {
            for (std::vector<int>::iterator it = pids.begin(); it != pids.end(); ++it)
            {
               _stub->sendTraceQuerySignal(TraceQueryData(*it, traceQueryId__GET_STATEMACHINE_INFO, std::vector< ::std::string >()));
            }
         }
      }
   }
}


bool GetSMInfo::Handle(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateTraceQueryResultRequest >& data)
{
   if (data->getData().getQueryId() == traceQueryId__GET_STATEMACHINE_INFO)
   {
      if (data->getData().getPid() == 0)
      {
         //sendSMInfoEvent(0);
         _stub->sendTraceQuerySignal(TraceQueryData(0, traceQueryId__GET_STATEMACHINE_INFO, std::vector< ::std::string >()));
      }
      else
      {
         std::vector<std::string> vecData = ::hmibase::util::split(data->getData().getQueryInput()[0], '\n');
         std::vector<std::string>::iterator it = vecData.begin();

         ETG_TRACE_FATAL(("#### HMI_SMInfo BEGIN ####"));
         while (it != vecData.end())
         {
            ETG_TRACE_FATAL(("%s", (*it).c_str()));
            ++it;
         }
         ETG_TRACE_FATAL(("#### HMI_SMInfo END ####"));
      }
      return true;
   }
   return false;
}


ETG_I_CMD_DEFINE((TraceCommand, "SMInfo"))
ETG_I_CMD_DEFINE((TraceCommand, "Get_SMInfo"))
void GetSMInfo::TraceCommand()
{
   if (GetInstance()._stub)
   {
      GetSMInfoPayload payload;
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "SMInfo %s", ETG_I_STRING))
ETG_I_CMD_DEFINE((TraceCommand, "Get_SMInfo %s", ETG_I_STRING))
void GetSMInfo::TraceCommand(const char* appName)
{
   if (GetInstance()._stub)
   {
      GetSMInfoPayload payload = appName;
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
