/* ***************************************************************************************
* FILE:          GetPossibleTouchPointForListElem.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GetPossibleTouchPointForListElem.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_GETPOSSIBLETOUCHPOINTFORLISTELEM_H
#define HMIBASE_TRACE_COMMAND_GETPOSSIBLETOUCHPOINTFORLISTELEM_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

struct GetPossibleTouchPointForListElemPayload
{
   std::string listId;
   std::string listElemIdx;

   GetPossibleTouchPointForListElemPayload(const char* id, const char* idx) : listId(id), listElemIdx(idx)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const GetPossibleTouchPointForListElemPayload& payload)
   {
      os << payload.listId;
      os << payload.listElemIdx;
      return os;
   }
};


class GetPossibleTouchPointForListElem :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< GetPossibleTouchPointForListElemPayload >
{
   private:

      GetPossibleTouchPointForListElem();

   public:
      virtual ~GetPossibleTouchPointForListElem();

      static GetPossibleTouchPointForListElem& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< GetPossibleTouchPointForListElemPayload > >& payload);

      static void TraceCommand(const char* listId, const char* listElemIndex);
};


}
}


}
#endif
