/* ***************************************************************************************
* FILE:          GetAllLoadedScenes.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GetAllLoadedScenes.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#ifndef HMIBASE_TRACE_COMMAND_GETLOADEDSCENES_H
#define HMIBASE_TRACE_COMMAND_GETLOADEDSCENES_H

#include "asf/core/BaseComponent.h"
#include "asf/core/Timer.h"
#include <string.h>
#include <map>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/TraceQueryResponseHandler.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

enum enViewCategory
{
   LOADED,
   ACTIVE_RENDERED,
   ACTIVE_NOTRENDERED,
   INACTIVE
};


struct GetAllViewsPayload
{
   enViewCategory category;

   GetAllViewsPayload(enViewCategory a) : category(a)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const GetAllViewsPayload& payload)
   {
      os << payload.category;
      return os;
   }
};


class GetAllLoadedScenes :
   public ::hmibase::trace::command::TraceCmdHandler,
   public asf::core::LocalMessageCallbackIF1< GetAllViewsPayload >,
   public ::hmibase::trace::TraceQueryResponseHandler
{
   private:

      GetAllLoadedScenes();
      enViewCategory _currentRequest;

   public:
      virtual ~GetAllLoadedScenes();

      static GetAllLoadedScenes& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< GetAllViewsPayload > >& payload);

      static void TraceCommand(enViewCategory e = LOADED);
      virtual void Configure(HMIBaseTraceCmds* baseComponent);
      virtual bool Handle(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateTraceQueryResultRequest >& data);
};


}
}


}
#endif
