/* ***************************************************************************************
* FILE:          AbortSBAnimation.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AbortSBAnimation.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "AbortSBAnimation.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::AbortSBAnimation::
#include "trcGenProj/Header/AbortSBAnimation.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

AbortSBAnimation& AbortSBAnimation::GetInstance()
{
   static AbortSBAnimation theInstance;
   return theInstance;
}


AbortSBAnimation::AbortSBAnimation()
{
   ETG_I_REGISTER_FILE();
}


AbortSBAnimation::~AbortSBAnimation()
{
   ETG_I_UNREGISTER_FILE();
}


void AbortSBAnimation::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple0 >& /*payload*/)
{
   if (_stub)
   {
      std::vector<int> pids;
      if (_stub->getClientsPid("", pids))
      {
         if (pids.size() > 0)
         {
            _stub->sendTraceQuerySignal(TraceQueryData(pids[0], traceQueryId__ABORT_SB_ANIMATIONS, std::vector< ::std::string >()));
         }
      }
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "SB_Abort_Animations"))
void AbortSBAnimation::TraceCommand()
{
   if (GetInstance()._stub)
   {
      GetInstance()._stub->sendLocalMessage(GetInstance());
   }
}


}
}


}
