/* ***************************************************************************************
* FILE:          HMIBaseTraceCmds.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HMIBaseTraceCmds.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBaseTraceCmds_h
#define HMIBaseTraceCmds_h

#include "asf/core/BaseComponent.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsStub.h"
#include <map>
#include <string>
#include <set>
#include "hmibase/trace/TraceQueryResponseHandler.h"

namespace hmibase {
namespace trace {

class HMIBaseTraceCmds:   public asf::core::BaseComponent
   , public bosch::cm::ai::hmi::appctrl::trace::Commands::CommandsStub
{
   private:

      struct clientInfo
      {
         pid_t pid;
         std::vector<unsigned int> surfaceIds;
      };

      std::map<std::string, clientInfo> _clientMap;
      std::set<hmibase::trace::TraceQueryResponseHandler*> _traceQueryResponseHandler;

   public:
      HMIBaseTraceCmds();
      virtual ~HMIBaseTraceCmds();

      void RegisterMethodHandler(::hmibase::trace::TraceQueryResponseHandler* handler);
      void DeregisterMethodHandler(::hmibase::trace::TraceQueryResponseHandler* handler);

      virtual void onUpdateTraceQueryResultRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateTraceQueryResultRequest >&);
      virtual void onUpdateClientStatusRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateClientStatusRequest >& request);

      void GetClientPids(std::vector<pid_t>& pids);
      bool getClientsPid(const std::string& clientName, std::vector<pid_t>& result);
      void GetClientNameFromPid(pid_t pid, std::string& s);

      static void TraceCmd_NotProcessedMsg(const unsigned char* pcu8Data);
};


}
}


#endif
