/* ***************************************************************************************
* FILE:          lint_deactivation.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  lint_deactivation.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __lint_deactivation_
#define __lint_deactivation_

// Useless declaration
// SYNCBLOCK_LOG_SET_REALM: Framework/AppUtils/SyncBlock define to nothing. Define is necessary for building libsyncblock
//lint -emacro(19, SYNCBLOCK_LOG_SET_REALM)

// Warning 429: Custodial pointer 'Symbol' (Location) has not been freed or returned
//lint -sem(std::vector::push_back, custodial(1))
//lint -sem(Courier::AssetConfiguration::Add, custodial(1))
//lint -sem(FeatStd::Internal::Vector::Add, custodial(1))

// Shift left of signed quantity (long)
//lint -emacro(703, __FD_MASK)

// do ... while(0);
//lint -emacro(717, DLT_REGISTER_APP)
//lint -emacro(717, DLT_REGISTER_CONTEXT)
//lint -emacro(717, DLT_UNREGISTER_APP)
//lint -emacro(717, DLT_UNREGISTER_CONTEXT)
//lint -emacro(717, __FD_ZERO)
//lint -emacro(717, SYNCBLOCK_LOG)

// local macro 'WAYLAND_VERSION_X_Y'  not referenced
// Deactivated as long as no special implementation for wayland X Y is necessary
//lint -esym(750, WAYLAND_VERSION_1_3)

// Redundant declaration for symbol 'Symbol' previously declared at Location
//lint -esym(763, AppPlatform::AppEnvironment)
//lint -esym(763, AppViewHandler)
//lint -esym(763, BaseButtonWidget2D)
//lint -esym(763, BaseWidget2D)
//lint -esym(763, ButtonWidget2D)
//lint -esym(763, Candera::Animation::AnimationController)
//lint -esym(763, Candera::Appearance)
//lint -esym(763, Candera::Bitmap)
//lint -esym(763, Candera::Camera)
//lint -esym(763, Candera::Camera2D)
//lint -esym(763, Candera::Scene2D)
//lint -esym(763, Candera::Node)
//lint -esym(763, Candera::Node2D)
//lint -esym(763, Candera::Mesh)
//lint -esym(763, Candera::Rectangle)
//lint -esym(763, Candera::RenderTarget)
//lint -esym(763, Candera::RenderTarget2D)
//lint -esym(763, Candera::Candera::Scene2D)
//lint -esym(763, Candera::Vector2)
//lint -esym(763, Candera::VertexGeometry)
//lint -esym(763, Candera::View)
//lint -esym(763, Candera::Widget2D)
//lint -esym(763, Candera::Vector2)
//lint -esym(763, Courier::InputHandling::Wayland::WaylandEventHook)
//lint -esym(763, Courier::FrameworkWidget)
//lint -esym(763, Courier::Message)
//lint -esym(763, Courier::MessageReferrer)
//lint -esym(763, Courier::View)
//lint -esym(763, Courier::ViewId)
//lint -esym(763, Courier::ViewScene)
//lint -esym(763, DoubleFunction)
//lint -esym(763, FManager)
//lint -esym(763, Focus::FAppConfig)
//lint -esym(763, Focus::FAppState)
//lint -esym(763, Focus::FConfigInfo)
//lint -esym(763, Focus::FControllerListMap::FControllerListMap)
//lint -esym(763, Focus::FGroup)
//lint -esym(763, Focus::FManager)
//lint -esym(763, Focus::FMsgQueue)
//lint -esym(763, Focus::FocusableVisitor)
//lint -esym(763, Focus::Focusable)
//lint -esym(763, Focus::FSession)
//lint -esym(763, Focus::FStateInfo)
//lint -esym(763, Focus::FViewConfig)
//lint -esym(763, Focus::FWidget)
//lint -esym(763, Focus::FWidgetConfig)
//lint -esym(763, IApplicationSettings)
//lint -esym(763, IGestureListener)
//lint -esym(763, Util::Timer)
//lint -esym(763, Transitions::Transition)

// Expression involving variable 'Symbol' possibly depends on order of evaluation (must be checked thoroughly before deactivation)
//lint -esym(864, offscreen)
//lint -esym(864, popups)
//lint -esym(864, viewHandler)

// data member 'Symbol' has zero size
//lint -esym(1501, syncblock::CtrlBlk::inst)

// defined object 'Symbol' has no nonstatic data members
//lint -esym(1502, appDataCleanTraverser)
//lint -esym(1502, ASH::BitmapBrushBlendSerializer)
//lint -esym(1502, ASH::BitmapBrushColorBlendSerializer)
//lint -esym(1502, ASH::Camera2DSerializer)
//lint -esym(1502, ASH::Group2DSerializer)
//lint -esym(1502, ASH::MirrorBitmapBrushBlendSerializer)
//lint -esym(1502, ASH::RenderNodeSerializer)
//lint -esym(1502, ASH::Scene2DSerializer)
//lint -esym(1502, ASH::SolidColorBrushBlendSerializer)
//lint -esym(1502, ASH::TextBrushBlendSerializer)
//lint -esym(1502, DefaultGizmoWidgetController)
//lint -esym(1502, hmibase::util::_initStrUtf8)
//lint -esym(1502, hmibase::trace::WidgetFinderCallback)
//lint -esym(1502, hmibase::trace::PrintAllVisibleTextCallback)
//lint -esym(1502, hmibase::trace::PrintTextInListCallback)
//lint -esym(1502, _instance)
//lint -esym(1502, invalidateLayoutViewVisitor)
//lint -esym(1502, l_name_) defined object has no nonstatic data members
//lint -esym(1502, objSort)
//lint -esym(1502, oRenderer)
//lint -esym(1502, resetClippingTraverser)
//lint -esym(1502, RichText::RichTextRenderer::TextContext::m_oTextRenderer)
//lint -esym(1502, textBrushCloneTraverser)
//lint -esym(1502, Candera::TextRendering::TextRenderer)
//lint -esym(1502, traverser)
//lint -esym(1502, Util::Internal::ScopedCriticalSection)

// Function may throw exception '...' in destructor
//lint -esym(1551, AnimationWidget2D::~AnimationWidget2D)
//lint -esym(1551, AnimationElementsContainer::~AnimationElementsContainer)
//lint -esym(1551, AnimationHelperInterface::~AnimationHelperInterface)
//lint -esym(1551, AppPlatform::AppEnvironment::~AppEnvironment)
//lint -esym(1551, AppListDataProviderCache::~AppListDataProviderCache)
//lint -esym(1551, AppViewHandler::~AppViewHandler)
//lint -esym(1551, ArcCurvedMarginFunctionProviderWidget::~ArcCurvedMarginFunctionProviderWidget)
//lint -esym(1551, ASH::ASHManager::~ASHManager)
//lint -esym(1551, BaseWidget2D::~BaseWidget2D)
//lint -esym(1551, BusyIndicatorWidget2D::~BusyIndicatorWidget2D)
//lint -esym(1551, ButtonWidget2D::~ButtonWidget2D)
//lint -esym(1551, ButtonWidget2D::ButtonTimers::~ButtonTimers)
//lint -esym(1551, CgiApplicationBase::~CgiApplicationBase)
//lint -esym(1551, CGIAppViewFactoryBase::~CGIAppViewFactoryBase)
//lint -esym(1551, ContentProvider::~ContentProvider)
//lint -esym(1551, ControlTemplateInstance::~ControlTemplateInstance)
//lint -esym(1551, DelegateWidget2d::~DelegateWidget2D)
//lint -esym(1551, hmibase::util::cSemaphore::~cSemaphore)
//lint -esym(1551, hmibase::util::cStrUtf8::~cStrUtf8)
//lint -esym(1551, hmibase::util::cThread::~cThread)
//lint -esym(1551, hmibase::util::cUseCriticalSection::~cUseCriticalSection)
//lint -esym(1551, HMIHandWritingComponent::~HMIHandWritingComponent)
//lint -esym(1551, DataCompletionHandler::~DataCompletionHandler)
//lint -esym(1551, DataModel_HandWriting::~DataModel_HandWriting)
//lint -esym(1551, DataModel_List5Items::~DataModel_List5Items)
//lint -esym(1551, DataModelMediaPlayer::~DataModelMediaPlayer)
//lint -esym(1551, DataModelTunerFMAM::~DataModelTunerFMAM)
//lint -esym(1551, App::Core::DemoWidgetsHall::~DemoWidgetsHall)
//lint -esym(1551, DirectTextureConsumer2D::~DirectTextureConsumer2D)
//lint -esym(1551, DirectTextureProvider2D::~DirectTextureProvider2D)
//lint -esym(1551, DirectTextureConsumer3D::~DirectTextureConsumer3D)
//lint -esym(1551, DirectTextureProvider3D::~DirectTextureProvider3D)
//lint -esym(1551, DefaultFocusConsistencyChecker::~DefaultFocusConsistencyChecker)
//lint -esym(1551, DelegateWidget2D::~DelegateWidget2D)
//lint -esym(1551, DragDropDemo::~DragDropDemo)
//lint -esym(1551, DragDrop::DDAdorner::~DDAdorner)
//lint -esym(1551, DragDrop::DDAdornerGroup::~DDAdornerGroup)
//lint -esym(1551, DragDrop::DDManager::~DDManager)
//lint -esym(1551, SyncBlockProducerFactory::DrmBufferContainer::~DrmBufferContainer)
//lint -esym(1551, Focus::FCourierMessageQueue::~FCourierMessageQueue)
//lint -esym(1551, Focus::FCourierTimer::~FCourierTimer)
//lint -esym(1551, Focus::FMapContainer*)
//lint -esym(1551, Focus::FDataSet::FDataWrapperBase::~FDataWrapperBase)
//lint -esym(1551, Focus::FDataSet::~FDataSet)
//lint -esym(1551, Focus::FDefaultAnimationManager::~FDefaultAnimationManager)
//lint -esym(1551, Focus::FDefaultConsistencyChecker::~FDefaultConsistencyChecker)
//lint -esym(1551, Focus::FDefaultIpcManager::~FDefaultIpcManager)
//lint -esym(1551, Focus::FDefaultSessionManager::~FDefaultSessionManager)
//lint -esym(1551, Focus::FDefaultTaskManager::~FDefaultTaskManager)
//lint -esym(1551, Focus::Serialize::InfoSer::~InfoSer)
//lint -esym(1551, Focus::FVectorContainer<Focus::FTimerListener>::~FVectorContainer)
//lint -esym(1551, Focus::FVectorContainer<Focus::FWidgetConfig>::~FVectorContainer)
//lint -esym(1551, Focus::FVectorContainer<Focus::Focusable>::~FVectorContainer)
//lint -esym(1551, GestureDetector::~GestureDetector)
//lint -esym(1551, GetViewMetaInfo::~GetViewMetaInfo)
//lint -esym(1551, GuiComponentBase::~GuiComponentBase)
//lint -esym(1551, HanWangInterface::~HanWangInterface)
//lint -esym(1551, HandWriting_Util_Widget2D::~HandWriting_Util_Widget2D)
//lint -esym(1551, HMIRenderViewVisitor::~HMIRenderViewVisitor)
//lint -esym(1551, hmibase::trace::HMIBaseTraceCmds::~HMIBaseTraceCmds)
//lint -esym(1551, LineListWidget3D::~LineListWidget3D)
//lint -esym(1551, ListDataItem::~ListDataItem)
//lint -esym(1551, ListDataProvider::~ListDataProvider)
//lint -esym(1551, ListDataProviderBuilder::~ListDataProviderBuilder)
//lint -esym(1551, ListImplementation::~ListImplementation)
//lint -esym(1551, ListImplementation::~ListImplementation)
//lint -esym(1551, App::Core::MediaGui::~MediaGui)
//lint -esym(1551, App::Core::MediaHall::~MediaHall)
//lint -esym(1551, Candera::MemoryMappedAssetRepository::~MemoryMappedAssetRepository)
//lint -esym(1551, OPSWidget2D::~OPSWidget2D)
//lint -esym(1551, OPS_AnimationHelperInterface::~OPS_AnimationHelperInterface)
//lint -esym(1551, OverlayLayouterWidget2D::~OverlayLayouterWidget2D)
//lint -esym(1551, hmibase::apphmi_master::audio::ResourceController::~ResourceController)
//lint -esym(1551, RichText::TextChunk::~TextChunk)
//lint -esym(1551, RichText::RichText::~RichText)
//lint -esym(1551, RichText::RichTextChunk::~RichTextChunk)
//lint -esym(1551, RichText::Paragraph::~Paragraph)
//lint -esym(1551, RichText::TextArea::~TextArea)
//lint -esym(1551, RichTextBaseWidget2D::~RichTextBaseWidget2D)
//lint -esym(1551, SceneTransitionMediator::~SceneTransitionMediator)
//lint -esym(1551, ScrollableTextWidget2D::~ScrollableTextWidget2D)
//lint -esym(1551, SyncBlockProducerFactory::~SyncBlockProducerFactory)
//lint -esym(1551, SpellerWidget2D::~SpellerWidget2D)
//lint -esym(1551, StepAnimationTimerManager::~StepAnimationTimerManager)
//lint -esym(1551, StepAnimationWidget2D::~StepAnimationWidget2D)
//lint -esym(1551, SwipingListContentUpdater::~SwipingListContentUpdater)
//lint -esym(1551, hmibase::services::hmiappctrl::StubHandler::~StubHandler)
//lint -esym(1551, Swiper::~Swiper)
//lint -esym(1551, SwipingListContentUpdater::~SwipingListContentUpdater)
//lint -esym(1551, App::Core::Test_03Hall::~Test_03Hall)
//lint -esym(1551, TextWidget2D::~TextWidget2D)
//lint -esym(1551, TextWidget2DV1::~TextWidget2DV1)
//lint -esym(1551, TextWidget2DV2::~TextWidget2DV2)
//lint -esym(1551, TextExtensionWidget2D::~TextExtensionWidget2D)
//lint -esym(1551, Touchable2D::~Touchable2D)
//lint -esym(1551, Transitions::Transition::~Transition)
//lint -esym(1551, Transitions::TransitionMessageReceiver::~TransitionMessageReceiver)
//lint -esym(1551, Transitions::ZoomTransition::~ZoomTransition)
//lint -esym(1551, Transitions::TransitionMessageReceiver::~TransitionMessageReceiver)
//lint -esym(1551, App::Core::TunerGui::~TunerGui)
//lint -esym(1551, Util::Internal::TimerThread::~TimerThread)
//lint -esym(1551, Util::Timer::~Timer)
//lint -esym(1551, Courier::InputHandling::Wayland::WaylandContext::~WaylandContext)
//lint -esym(1551, Courier::InputHandling::Wayland::UnloadSynchronizedDisplay::~UnloadSynchronizedDisplay)

// Warning 1509: prio2: The destructor of derived class 'Focus::Serialize::BoundsDataSer' is non-trivial,
// but the non-trivial destructor of base class 'Focus::Serialize::DataItemSerBase<Candera::Rectangle>' is not virtual
// !!Seems to be a false positive Lint warning because the destructor of Rectangle is trivial!!
//lint -esym(1509, Focus::Serialize::BoundsDataSer)

// Explicit specialialization does not occur in the same file as corresponding function template 'Symbol' (Location)
//lint -esym(1576, Focus::Serialize::InfoSer::getIdFromIndex)
//lint -esym(1576, Focus::Serialize::InfoSer::getTable)

// Pointer member 'Symbol' (Location) might have been freed by a separate function but no '-sem(Name,cleanup)' was seen
//lint -esym(1579, hmibase::util::cStrUtf8::_pUtf8String)

// Constructor 'Symbol' has private access specification
//lint -esym(1704, hmibase::apphmi_master::audio::AudioControllerObjectManager::AudioControllerObjectManager*)
//lint -esym(1704, AnimatedPropertyWrapper::AnimatedPropertyWrapper)
//lint -esym(1704, AnimationWrapper::AnimationWrapper)
//lint -esym(1704, AppTask::AppTask)
//lint -esym(1704, AppViewSettings::AppViewSettings)
//lint -esym(1704, ASH::ASHManager::ASHManager)
//lint -esym(1704, ASH::ScmlWriter::ScmlWriter)
//lint -esym(1704, BaseButtonTouchHandler::BaseButtonTouchHandler)
//lint -esym(1704, CGIAppViewFactoryBase::CGIAppViewFactoryBase)
//lint -esym(1704, CollapsingOverlayLayouter::CollapsingOverlayLayouter)
//lint -esym(1704, DefaultActivityTimerListener::DefaultActivityTimerListener)
//lint -esym(1704, DefaultFocusConsistencyChecker::DefaultFocusConsistencyChecker)
//lint -esym(1704, DefaultFocusManagerConfigurator::DefaultFocusManagerConfigurator)
//lint -esym(1704, DefaultFocusReqHandler::DefaultFocusReqHandler)
//lint -esym(1704, DefaultHKtoEnterKeyConverter::DefaultHKtoEnterKeyConverter)
//lint -esym(1704, DefaultListRotaryController::DefaultListRotaryController)
//lint -esym(1704, DragDrop::DDAdorner::DDAdorner)
//lint -esym(1704, DragDrop::DDManager::DDManager)
//lint -esym(1704, DragDropDemo::DragDropDemo)
//lint -esym(1704, EllipseButtonTouchHandler::EllipseButtonTouchHandler)
//lint -esym(1704, FlexCanvasLayouter::FlexCanvasLayouter)
//lint -esym(1704, FlexDropdownListLayouter::FlexDropdownListLayouter)
//lint -esym(1704, Focus::Focusable::Focusable)
//lint -esym(1704, Focus::FWidget::FWidget)
//lint -esym(1704, Focus::FGroup::FGroup)
//lint -esym(1704, Focus::FActiveViewGroup::FActiveViewGroup)
//lint -esym(1704, Focus::FComponentBase*::FComponentBase)
//lint -esym(1704, Focus::FContainerConfig*::FContainerConfig)
//lint -esym(1704, Focus::FAppConfig::FAppConfig)
//lint -esym(1704, Focus::FViewConfig::FViewConfig)
//lint -esym(1704, Focus::FWidgetConfig::FWidgetConfig)
//lint -esym(1704, Focus::FConfigInfo::FConfigInfo)
//lint -esym(1704, Focus::FControllerListMap::FControllerListMap)
//lint -esym(1704, Focus::FCourierTimer::FCourierTimer)
//lint -esym(1704, Focus::FCourierMessageQueue::FCourierMessageQueue)
//lint -esym(1704, Focus::FCourierOutputMsgHandler::FCourierOutputMsgHandler)
//lint -esym(1704, Focus::FDataSet::FDataSet)
//lint -esym(1704, Focus::FGroupTraverser::FGroupTraverser)
//lint -esym(1704, Focus::FDefaultGroupTraverser::FDefaultGroupTraverser)
//lint -esym(1704, Focus::FGroupAscendingTraverser::FGroupAscendingTraverser)
//lint -esym(1704, Focus::FGroupDescendingTraverser::FGroupDescendingTraverser)
//lint -esym(1704, Focus::FIpcAdapter::FIpcAdapter)
//lint -esym(1704, Focus::FManager::FManager)
//lint -esym(1704, Focus::FManagerConfigurator::FManagerConfigurator)
//lint -esym(1704, Focus::FManagerConfiguration::FManagerConfiguration)
//lint -esym(1704, Focus::FSession::FSession)
//lint -esym(1704, Focus::FContainerState*::FContainerState)
//lint -esym(1704, Focus::FStateInfo::FStateInfo)
//lint -esym(1704, Focus::FAppState::FAppState)
//lint -esym(1704, Focus::FViewState::FViewState)
//lint -esym(1704, Focus::FTask::FTask)
//lint -esym(1704, Focus::FSessionUpdater::FSessionUpdater)
//lint -esym(1704, Focus::FDefaultAvgSessionUpdater::FDefaultAvgSessionUpdater)
//lint -esym(1704, Focus::FDefaultAvgBuilder::FDefaultAvgBuilder)
//lint -esym(1704, Focus::FAvg2FocusInfoUpdater::FAvg2FocusInfoUpdater)
//lint -esym(1704, Focus::FDefaultAvgManager::FDefaultAvgManager)
//lint -esym(1704, Focus::FDefaultConsistencyChecker::FDefaultConsistencyChecker)
//lint -esym(1704, Focus::FDefaultCourierInfoCollector::FDefaultCourierInfoCollector)
//lint -esym(1704, Focus::FDefaultCourierInfoPublisher::FDefaultCourierInfoPublisher)
//lint -esym(1704, Focus::FDefaultCrtAppState2SessionUpdater::FDefaultCrtAppState2SessionUpdater)
//lint -esym(1704, Focus::FDefaultSession2CrtAppStateUpdater::FDefaultSession2CrtAppStateUpdater)
//lint -esym(1704, Focus::FDefaultSlaveAppUpdater::FDefaultSlaveAppUpdater)
//lint -esym(1704, Focus::FDefaultEnterKeyController::FDefaultEnterKeyController)
//lint -esym(1704, Focus::FDefaultInputMsgProcessor::FDefaultInputMsgProcessor)
//lint -esym(1704, Focus::FDefaultIpcManager::FDefaultIpcManager)
//lint -esym(1704, Focus::DirectionalWidgetFinderVisitor::DirectionalWidgetFinderVisitor)
//lint -esym(1704, Focus::FDefaultJoystickController::FDefaultJoystickController)
//lint -esym(1704, Focus::FDefaultIpcCrtAppInfoPublisher::FDefaultIpcCrtAppInfoPublisher)
//lint -esym(1704, Focus::FDefaultIpcOtherAppsInfoCollector::FDefaultIpcOtherAppsInfoCollector)
//lint -esym(1704, Focus::FDefaultIpcOtherAppsStatePublisher::FDefaultIpcOtherAppsStatePublisher)
//lint -esym(1704, Focus::FDefaultSlaveAppUpdater::FDefaultSlaveAppUpdater)
//lint -esym(1704, Focus::FDefaultRotaryController::FDefaultRotaryController)
//lint -esym(1704, Focus::Serialize::FNameTable::FNameTable)
//lint -esym(1704, Focus::FDefaultSessionWatchdog::FDefaultSessionWatchdog)
//lint -esym(1704, Focus::FDefaultSessionManager::FDefaultSessionManager)
//lint -esym(1704, Focus::FDefaultTaskFactory::FDefaultTaskFactory)
//lint -esym(1704, Focus::FDefaultTaskManager::FDefaultTaskManager)
//lint -esym(1704, Focus::FViewSpecificVisibilityManager::FViewSpecificVisibilityManager)
//lint -esym(1704, Focus::FDefaultVisibilityManager::FDefaultVisibilityManager)
//lint -esym(1704, FocusOnTouchHandler::FocusOnTouchHandler)
//lint -esym(1704, GestureHandler::GestureHandler)
//lint -esym(1704, GuiComponentBase::GuiComponentBase)
//lint -esym(1704, HallComponentBase::HallComponentBase)
//lint -esym(1704, hmibase::app::base::lcm::LcmHandler::LcmHandler)
//lint -esym(1704, ListDataItem::ListDataItem)
//lint -esym(1704, ListDataProvider::ListDataProvider)
//lint -esym(1704, ListDataProviderBuilder::ListItem::ListItem)
//lint -esym(1704, MarginPropertySetter::MarginPropertySetter)
//lint -esym(1704, hmibase::util::cSemaphore::cSemaphore)
//lint -esym(1704, hmibase::trace::GuiInfo::GuiInfo)
//lint -esym(1704, hmibase::trace::StartupInvestigation::StartupInvestigation)
//lint -esym(1704, hmibase::trace::TraceUtils::TraceUtils)
//lint -esym(1704, StartupSync::StartupSync)
//lint -esym(1704, ScreenBroker::Client::Client)
//lint -esym(1704, ScreenBroker::Internal::DBusXXServiceProxy::DBusXXServiceProxy)
//lint -esym(1704, ScreenBroker::Internal::GDBusServiceProxy::GDBusServiceProxy)
//lint -esym(1704, ScreenBroker::Internal::PluginManager::PluginManager)
//lint -esym(1704, ScreenBroker::Service::Service)
//lint -esym(1704, ScreenBroker::Synchronize::Synchronize)
//lint -esym(1704, ScreenBroker::Internal::DBusXXServiceAdaptor::DBusXXServiceAdaptor)
//lint -esym(1704, ScreenBroker::Internal::GDBusServiceAdaptor::GDBusServiceAdaptor)
//lint -esym(1704, ScreenBroker::PopupManager::PopupManager)
//lint -esym(1704, ScreenBroker::CriticalSectionLocker::CriticalSectionLocker)
//lint -esym(1704, ScreenBroker::CriticalSection::CriticalSection)
//lint -esym(1704, ScreenBroker::ScopeLogger::ScopeLogger)
//lint -esym(1704, ScreenBroker::KeyHandler::KeyHandler)
//lint -esym(1704, ScreenBroker::PopupManagerActivator::PopupManagerActivator)
//lint -esym(1704, ScreenBroker::ScreenBrokerActivator::ScreenBrokerActivator)
//lint -esym(1704, ScreenBroker::ScreenLayouter::ScreenLayouter)
//lint -esym(1704, SyncBlockConsumer::SyncBlockConsumer)
//lint -esym(1704, StepAnimationTimerManager::StepAnimationTimerManager)
//lint -esym(1704, TimerManager::TimerManager)
//lint -esym(1704, Transitions::DisplayConfigurationProviderProxy::DisplayConfigurationProviderProxy)
//lint -esym(1704, Transitions::ViewMapProxy::ViewMapProxy)
//lint -esym(1704, Transitions::ViewMessageSender::ViewMessageSender)

// default constructor not defined for class 'Name'
//lint -esym(1712, AbstractListModel)
//lint -esym(1712, AddChecker)
//lint -esym(1712, AppEnvironment)
//lint -esym(1712, AnimationWrapper)
//lint -esym(1712, ASHServer)
//lint -esym(1712, LinuxAcceptor)
//lint -esym(1712, LinuxSocket)
//lint -esym(1712, ButtonWidget2DFinderCallback)
//lint -esym(1712, ButtonTimerConfig)
//lint -esym(1712, CacheData)
//lint -esym(1712, Consumer)
//lint -esym(1712, ContentUpdateEvent)
//lint -esym(1712, CursorPosition)
//lint -esym(1712, CustomAnimationListener)
//lint -esym(1712, CgiApplicationBase)
//lint -esym(1712, cUseCriticalSection)
//lint -esym(1712, CloneNodeEvent)
//lint -esym(1712, DDAdornerGroup)
//lint -esym(1712, DDWidgetFinderCallback)
//lint -esym(1712, DefaultActivityTimerListener)
//lint -esym(1712, DefaultFocusConsistencyChecker)
//lint -esym(1712, DefaultFocusManagerConfigurator)
//lint -esym(1712, DefaultFocusReqHandler)
//lint -esym(1712, DefaultHKtoEnterKeyConverter)
//lint -esym(1712, DelayedBitmapImage2D)
//lint -esym(1712, DirectionalWidgetFinderVisitor)
//lint -esym(1712, DisposeEvent)
//lint -esym(1712, DownState)
//lint -esym(1712, DragGestureDetector)
//lint -esym(1712, EnablingTraverser)
//lint -esym(1712, ExpandableListViewModel)
//lint -esym(1712, FCourierOutputMsgHandler)
//lint -esym(1725, Focus::FCourierOutputMsgHandler::_viewHandler)
//lint -esym(1712, Focusable)
//lint -esym(1712, FWidget)
//lint -esym(1712, FViewWidgetId)
//lint -esym(1712, FAppViewWidgetId)
//lint -esym(1712, FComponentBase)
//lint -esym(1712, FContainerConfig)
//lint -esym(1712, FAppConfig)
//lint -esym(1712, FViewConfig)
//lint -esym(1712, FWidgetConfig)
//lint -esym(1712, FMapContainer)
//lint -esym(1712, FVectorContainer)
//lint -esym(1712, FGroup)
//lint -esym(1712, FMapContainer)
//lint -esym(1712, FDataWrapperBase)
//lint -esym(1712, FMarkerData)
//lint -esym(1712, FDataWrapperBase)
//lint -esym(1712, FGroupTraverser)
//lint -esym(1712, FDefaultGroupTraverser)
//lint -esym(1712, FGroupAscendingTraverser)
//lint -esym(1712, FGroupDescendingTraverser)
//lint -esym(1712, FManagerConfigurator)
//lint -esym(1712, FSession)
//lint -esym(1712, FGroupState)
//lint -esym(1712, FContainerState)
//lint -esym(1712, FAppState)
//lint -esym(1712, FViewState)
//lint -esym(1712, FTask)
//lint -esym(1712, FSessionUpdater)
//lint -esym(1712, FDefaultAvgBuilder)
//lint -esym(1712, FAvg2FocusInfoUpdater)
//lint -esym(1712, FDefaultAvgSessionUpdater)
//lint -esym(1712, FDefaultAvgManager)
//lint -esym(1712, FDefaultConsistencyChecker)
//lint -esym(1712, FDefaultCourierInfoCollector)
//lint -esym(1712, FDefaultCourierInfoPublisher)
//lint -esym(1712, FDefaultCrtAppState2SessionUpdater)
//lint -esym(1712, FDefaultCourierInfoCollector)
//lint -esym(1712, FDefaultCourierInfoPublisher)
//lint -esym(1712, FDefaultCrtAppState2SessionUpdater)
//lint -esym(1712, FDefaultSession2CrtAppStateUpdater)
//lint -esym(1712, FDefaultEnterKeyController)
//lint -esym(1712, FDefaultInputMsgProcessor)
//lint -esym(1712, FDefaultIpcManager)
//lint -esym(1712, FDefaultJoystickController)
//lint -esym(1712, FDefaultManagerConfigurator)
//lint -esym(1712, FDefaultIpcCrtAppInfoPublisher)
//lint -esym(1712, FDefaultIpcOtherAppsInfoCollector)
//lint -esym(1712, FDefaultIpcOtherAppsStatePublisher)
//lint -esym(1712, FDefaultSlaveAppUpdater)
//lint -esym(1712, FDefaultRotaryController)
//lint -esym(1712, FDefaultSerializer)
//lint -esym(1712, FDefaultSessionManager)
//lint -esym(1712, FDefaultSessionWatchdog)
//lint -esym(1712, FDefaultTaskFactory)
//lint -esym(1712, FDefaultTaskManager)
//lint -esym(1712, FDefaultVisibilityManager)
//lint -esym(1712, FocusOnTouchHandler)
//lint -esym(1712, FViewSpecificVisibilityManager)
//lint -esym(1712, FixedNumberOfLinesLayoutStrategy)
//lint -esym(1712, GestureDetector)
//lint -esym(1712, GestureHandler)
//lint -esym(1712, GridHorizontalListItemAdder)
//lint -esym(1712, GridListItemAdder)
//lint -esym(1712, GridVerticalListItemAdder)
//lint -esym(1712, HanWangInterface)
//lint -esym(1712, HorizontalGridItemAdderFactory)
//lint -esym(1712, IndexedWidgetFinderCallback)
//lint -esym(1712, Info)
//lint -esym(1712, LegacyTouchDetector)
//lint -esym(1712, ListDataItem)
//lint -esym(1712, ListDataProvider)
//lint -esym(1712, ListDataProviderBuilder)
//lint -esym(1712, ListDataProviderBuilder)
//lint -esym(1712, ListItem)
//lint -esym(1712, ListItemAdder)
//lint -esym(1712, ListWidgetFinderCallback)
//lint -esym(1712, MandatoryBreakCheckLayoutStrategy)
//lint -esym(1712, MaxPositionData)
//lint -esym(1712, MemoryMappedAssetRepository)
//lint -esym(1712, ModeSpecificParameters)
//lint -esym(1712, OrientationOperator)
//lint -esym(1712, Producer)
//lint -esym(1712, Ref)
//lint -esym(1712, RawGestureDetector)
//lint -esym(1712, RotateGestureDetector)
//lint -esym(1712, ScmlWriter)
//lint -esym(1712, SpreadGestureDetector)
//lint -esym(1712, surfaceTouchGeometry)
//lint -esym(1712, stateInfo)
//lint -esym(1712, StackListItemAdder)
//lint -esym(1712, SyncBlock)
//lint -esym(1712, SwipeGestureDetector)
//lint -esym(1712, SwipingStateMachine)
//lint -esym(1712, TapGestureDetector)
//lint -esym(1712, *Transition)
//lint -esym(1712, TriangleButtonTouchHandler)
//lint -esym(1712, UnloadSynchronizedDisplay)
//lint -esym(1712, VerticalGridItemAdderFactory)
//lint -esym(1712, WidgetIdFinderCallback)
//lint -esym(1712, WidgetInstanceFinderCallback)
//lint -esym(1712, WidgetFinderCallback)
//lint -esym(1712, WidgetInfoCallback)

// class member 'Symbol' is a reference (must be checked thoroughly before deactivation)
//lint -esym(1725, AppPlatform::AppEnvironment::_appSettings)
//lint -esym(1725, AnimationWrapper::_viewHandler)
//lint -esym(1725, ASH::ASHServer::_data)
//lint -esym(1725, ASH::ScmlWriter::_stream)
//lint -esym(1725, CgiApplicationBase::_hmiAppCtrlProxyHandler)
//lint -esym(1725, DefaultActivityTimerListener::_manager)
//lint -esym(1725, DefaultHKtoEnterKeyConverter::_manager)
//lint -esym(1725, DefaultFocusReqHandler::_manager)
//lint -esym(1725, DefaultFocusConsistencyChecker::_manager)
//lint -esym(1725, EnablingTraverser::mViewScene)
//lint -esym(1725, FixedNumberOfLinesLayoutStrategy::m_isMandatoryBreak)
//lint -esym(1725, Focus::FWidget::Config)
//lint -esym(1725, Focus::FWidgetConfig::View)
//lint -esym(1725, Focus::FViewConfig::App)
//lint -esym(1725, Focus::FCourierOutputMsgHandler::_viewHandler)
//lint -esym(1725, Focus::FGroupTraverser::_visitor)
//lint -esym(1725, Focus::FGroupTraverser::_rootGroup)
//lint -esym(1725, Focus::FManagerConfigurator::_configuration)
//lint -esym(1725, Focus::FTask::_manager)
//lint -esym(1725, Focus::FDefaultAnimationManager::_manager)
//lint -esym(1725, Focus::FDefaultAnimationManager::_viewHandler)
//lint -esym(1725, Focus::FDefaultAvgManager::_manager)
//lint -esym(1725, Focus::FDefaultConsistencyChecker::_manager)
//lint -esym(1725, Focus::FDefaultConsistencyChecker::_viewHandler)
//lint -esym(1725, Focus::FDefaultEnterKeyController::_manager)
//lint -esym(1725, Focus::FDefaultIpcManager::_manager)
//lint -esym(1725, Focus::FDefaultIpcManager::_ipcAdapter)
//lint -esym(1725, Focus::DirectionalWidgetFinderVisitor::_originWidget)
//lint -esym(1725, Focus::FDefaultJoystickController::_manager)
//lint -esym(1725, Focus::FDefaultManagerConfigurator::_manager)
//lint -esym(1725, Focus::FDefaultRotaryController::_manager)
//lint -esym(1725, Focus::FDefaultSessionWatchdog::_manager)
//lint -esym(1725, Focus::FDefaultSessionManager::_manager)
//lint -esym(1725, Focus::FDefaultTaskFactory::_manager)
//lint -esym(1725, Focus::FDefaultTaskManager::_manager)
//lint -esym(1725, Focus::FDefaultVisibilityManager::_manager)
//lint -esym(1725, Focus::FViewSpecificVisibilityManager::_manager)
//lint -esym(1725, FocusOnTouchHandler::_manager)
//lint -esym(1725, FocusOnTouchHandlermanager)
//lint -esym(1725, GuiComponentBase::_appSettings)
//lint -esym(1725, MandatoryBreakCheckLayoutStrategy::m_isMandatoryBreak)

// New in constructor for class 'Name' which has no assignment operator
//lint -esym(1732, DrmBufferContainer)
//lint -esym(1732, MasterHall)
//lint -esym(1732, MediaHall)
//lint -esym(1732, DataModelMediaPlayer)
//lint -esym(1732, DataModelTunerFMAM)

// New in constructor for class 'Name' which has no copy constructor
//lint -esym(1733, DrmBufferContainer)
//lint -esym(1733, MasterHall)
//lint -esym(1733, MediaHall)
//lint -esym(1733, DataModelMediaPlayer)
//lint -esym(1733, DataModelTunerFMAM)

// Virtual function 'Symbol' has default parameter (must checked be thoroughly before deactivation)
//lint -esym(1735, Courier::RenderTargetInvalidatingViewScene*)
//lint -esym(1735, Focus::FAvgManager::isCurrentFocusAvailable)
//lint -esym(1735, Focus::FAvgManager::getFocus)
//lint -esym(1735, Focus::FDefaultAvgManager::isCurrentFocusAvailable)
//lint -esym(1735, Focus::FDefaultAvgManager::getFocus)
//lint -esym(1735, Transitions::PageFlip3DView::Invalidate)
//lint -esym(1735, Transitions::Transition3DView::Invalidate)
//lint -esym(1735, hmibase::ViewScene2D::Invalidate)

// Member function 'Symbol' could be made const
//lint -esym(1762, *)
//lint -esym(1762, *add*)
//lint -esym(1762, *begin*)
//lint -esym(1762, *changed*)
//lint -esym(1762, *Changed*)
//lint -esym(1762, *cleanup*)
//lint -esym(1762, *Cleanup*)
//lint -esym(1762, *clear*)
//lint -esym(1762, *create*)
//lint -esym(1762, *Create*)
//lint -esym(1762, *execute*)
//lint -esym(1762, *handle*)
//lint -esym(1762, *move*)
//lint -esym(1762, *normalize*)
//lint -esym(1762, *onCourierMessage*)
//lint -esym(1762, *remove*)
//lint -esym(1762, *send*)
//lint -esym(1762, *Send*)
//lint -esym(1762, *set*)
//lint -esym(1762, *Set*)
//lint -esym(1762, *start*)
//lint -esym(1762, *Start*)
//lint -esym(1762, *switch*)
//lint -esym(1762, *Switch*)
//lint -esym(1762, *terminate*)
//lint -esym(1762, *unload*)
//lint -esym(1762, *Unload*)
//lint -esym(1762, *update*)

// Member function 'Symbol' marked as const indirectly modifies (must be checked thoroughly before deactivation)
//lint -esym(1763, ASH::ASHManager::getViewHandler)
//lint -esym(1763, BaseWidget2D::GetFocusParentNode)
//lint -esym(1763, ButtonExtension::GetButtonWidget)
//lint -esym(1763, ButtonTextExtensionWidget2D::GetTextWidget)
//lint -esym(1763, DelegateWidget2D::getController)
//lint -esym(1763, DelegateWidget2D::getControllerData)
//lint -esym(1763, DirectTextureConsumer3D::GetCamera)
//lint -esym(1763, DirectTextureProvider3D::GetCamera)
//lint -esym(1763, DirectTextureProvider3D::GetGraphicDeviceUnit)
//lint -esym(1763, DragDrop::DDManager::getViewHandler)
//lint -esym(1763, DragDrop::DDWidgetFinderCallback::GetWidget)
//lint -esym(1763, EditFieldWidget2D::getBackgroundNode)
//lint -esym(1763, EditFieldWidget2D::getCursorNode)
//lint -esym(1763, EditFieldWidget2D::copGetEntryTextNode)
//lint -esym(1763, EditFieldWidget2D::copGetMatchTextNode)
//lint -esym(1763, FocusGroupBase::getFocusMarkerAnimationWidget)
//lint -esym(1763, Focus::Focusable::getParent)
//lint -esym(1763, Focus::FWidgetConfig::getParent)
//lint -esym(1763, Focus::FDataSet::FDataWrapperBase::getNext)
//lint -esym(1763, Focus::FManagerConfiguration::getActivityTimer)
//lint -esym(1763, Focus::FManagerConfiguration::getAnimationManager)
//lint -esym(1763, Focus::FManagerConfiguration::getWatchdogTimer)
//lint -esym(1763, Focus::FManagerConfiguration::getAvgManager)
//lint -esym(1763, Focus::FManagerConfiguration::getConsistencyChecker)
//lint -esym(1763, Focus::FManagerConfiguration::getVisibilityManager)
//lint -esym(1763, Focus::FManagerConfiguration::getInputMsgChecker)
//lint -esym(1763, Focus::FManagerConfiguration::getInputMsgQueue)
//lint -esym(1763, Focus::FManagerConfiguration::getIpcManager)
//lint -esym(1763, Focus::FManagerConfiguration::getOutputMsgHandler)
//lint -esym(1763, Focus::FManagerConfiguration::getSessionManager)
//lint -esym(1763, Focus::FManagerConfiguration::getTaskFactory)
//lint -esym(1763, Focus::FManagerConfiguration::getTaskManager)
//lint -esym(1763, Focus::DirectionalWidgetFinderVisitor::getWidget)
//lint -esym(1763, Focus::FDefaultManagerConfigurator::getWatchdogTimer)
//lint -esym(1763, Focus::FDefaultManagerConfigurator::getViewHandler)
//lint -esym(1763, Focus::FDefaultManagerConfigurator::getActivityTimer)
//lint -esym(1763, Focus::Serialize::FDefaultSerializer::getInfo)
//lint -esym(1763, FocusGroupBase::getFocusMarkerNode)
//lint -esym(1763, Courier::InputHandling::Wayland::WaylandContext::Get*)
//lint -esym(1763, LineListWidget3D::getAssetProvider)
//lint -esym(1763, Transitions::PageFlip3DView::Get*)
//lint -esym(1763, Transitions::CustomAnimationListener::GetTransition)
//lint -esym(1763, Transitions::Node*ValuePropertySetter::Get*)
//lint -esym(1763, Transitions::CustomAnimationListener::GetTransition)
//lint -esym(1763, Transitions::Transition3DView::Get*)
//lint -esym(1763, WidgetFinderCallback::GetWidget)
//lint -esym(1763, WidgetIdFinderCallback<ButtonWidget2D>::GetWidget)

// Virtual function 'Symbol' has an access (String) different from the access (String) in the base class (String)
//lint -esym(1768, AppPlatform::Impl::AppEnvironment::Cleanup)
//lint -esym(1768, AppPlatform::Impl::AppEnvironment::GetAssetRepo)
//lint -esym(1768, AppViewHandler::OnMessageViewTreeOnly)
//lint -esym(1768, ButtonExtensionWidget2D::Update)
//lint -esym(1768, ButtonImageWidget2D::OnChanged)
//lint -esym(1768, ButtonImageWidget2D::Update)
//lint -esym(1768, ButtonTextColorWidget2D::OnChanged)
//lint -esym(1768, ButtonTextColorWidget2D::Update)
//lint -esym(1768, ButtonTextScrollWidget2D::OnChanged)
//lint -esym(1768, ButtonTextScrollWidget2D::OnMessage)
//lint -esym(1768, ButtonTextScrollWidget2D::Update)
//lint -esym(1768, CGIApp::createFocusManagerConfigurator)
//lint -esym(1768, CGIAppController::onCourierMessage)
//lint -esym(1768, Courier::InputHandling::Generic::GenericConsoleInputHandler::SetMode)
//lint -esym(1768, DragDropDemo::executeDrop)
//lint -esym(1768, DragDropDemo::isValidDestination)
//lint -esym(1768, DragDropDemo::isValidSource)
//lint -esym(1768, DragDropDemo::onCourierMessage)
//lint -esym(1768, DropDownListWidget2D::OnChanged)
//lint -esym(1768, EnablingTraverser::ProcessNode)
//lint -esym(1768, FlexDropdownListLayouter::Clone)
//lint -esym(1768, GridAutoArrangeWidget2D::Update)
//lint -esym(1768, GuiComponentBase::OnMessage)
//lint -esym(1768, HMIModelComponent::OnMessage)
//lint -esym(1768, ImageEffectWidget2D::OnChanged)
//lint -esym(1768, ImageEffectWidget2D::OnNodeChanged)
//lint -esym(1768, ImageEffectWidget2D::Update)
//lint -esym(1768, ImageSwitchWidget2D::CloneFrom)
//lint -esym(1768, ImageSwitchWidget2D::OnChanged)
//lint -esym(1768, ImageSwitchWidget2D::Update)
//lint -esym(1768, ListFocusControllerWidget2D::Update)
//lint -esym(1768, ListWidget2DSliderWidget2D::OnChanged)
//lint -esym(1768, MeterWidget2D::OnChanged)
//lint -esym(1768, ScrollableTextWidget2D::SetListener)
//lint -esym(1768, ScrollBarWidget2D::OnContentUpdated)
//lint -esym(1768, ScrollBarWidget2D::OnPositionReached)
//lint -esym(1768, SliderWidget2D::ComposerPropFilterFillerNodeConnected)
//lint -esym(1768, SliderWidget2D::ComposerPropFilterNotProgressbarMode)
//lint -esym(1768, SliderWidget2D::ComposerPropFilterNumOfSteps)
//lint -esym(1768, SliderWidget2D::ComposerPropFilterStepSize)
//lint -esym(1768, SolidColorEffectWidget2D::OnChanged)
//lint -esym(1768, SolidColorEffectWidget2D::OnNodeChanged)
//lint -esym(1768, SolidColorEffectWidget2D::Update)
//lint -esym(1768, TextBaseLineOffsetWidget2D::OnChanged)
//lint -esym(1768, TextBaseLineOffsetWidget2D::OnNodeChanged)
//lint -esym(1768, TextWidget2DV2PreprocessingContext::GetReferenceIterator)
//lint -esym(1768, TextWidget2DV2PreprocessingContext::Measure)
//lint -esym(1768, TextWidgetTextRenderContext::Blit)
//lint -esym(1768, TextWidgetTextRenderContext::GetClipRect)
//lint -esym(1768, TextWidgetTextRenderContext::GetGlyphCacheAccess)
//lint -esym(1768, TextWidgetTextRenderContext::IsCachingEnabled)
//lint -esym(1768, TextWidgetTextRenderContext::IsRenderingEnabled)
//lint -esym(1768, TextWidgetTextRenderContext::OnGlyphProcessing)
//lint -esym(1768, TextWidgetTextRenderContext::OnInit)
//lint -esym(1768, TextWidgetTextRenderContext::OnLineBreak)
//lint -esym(1768, TextureImageWidget3D::OnChanged)
//lint -esym(1768, TextureImageWidget3D::OnNodeChanged)
//lint -esym(1768, TwoDimensionSliderWidget2D::OnChanged)


// Could use dynamic_cast to downcast polymorphic type 'Courier::Message'
//lint -esym(1774, Candera::Display)
//lint -esym(1774, Candera::GraphicDeviceUnit)
//lint -esym(1774, Candera::Node)
//lint -esym(1774, Candera::WidgetBase)
//lint -esym(1774, Candera::Widget2D)
//lint -esym(1774, ControlTemplateCloneableWidget)
//lint -esym(1774, Courier::FrameworkWidget)
//lint -esym(1774, Courier::Message)
//lint -esym(1774, Courier::View)
//lint -esym(1774, hmibase::services::hmiappctrl::ProxyHandler)

// Base class 'Symbol' has no non-destructor virtual functions
//lint -esym(1790, AnimationFactory)
//lint -esym(1790, Candera::DynamicProperties::DynamicPropertySpecification<Candera::DynamicProperties::HostSpecification*)
//lint -esym(1790, ControlTemplateCloningStrategy::CloneNodeEvent)
//lint -esym(1790, ControlTemplateInstance)
//lint -esym(1790, CourierMessageMapTrace)
//lint -esym(1790, CourierMsclIdessageMapTrace)
//lint -esym(1790, DataModelBase)
//lint -esym(1790, Candera::DynamicProperties::DynamicPropertySpecification)
//lint -esym(1790, EventHub::Event)
//lint -esym(1790, Focus::Serialize::ItemIndexSerBase*)
//lint -esym(1790, Focus::Serialize::NamedItemSerBase*)
//lint -esym(1790, Focus::Serialize::ItemSerBase*)
//lint -esym(1790, Focus::Serialize::DataItemSerBase*)
//lint -esym(1790, Focus::FComponent*)
//lint -esym(1790, Focus::FComponentBase*)
//lint -esym(1790, Focus::FContainerState*)
//lint -esym(1790, Focus::FManagerConfiguration)
//lint -esym(1790, Focus::FMarkerData)
//lint -esym(1790, Focus::FSharedPtrMapContainer*)
//lint -esym(1790, FocusGroupBase)
//lint -esym(1790, HmiAsfComponentBase)
//lint -esym(1790, hmibase::util::cMutex)
//lint -esym(1790, SpellerWidget2DInterface)
//lint -esym(1790, syncblock::SyncBlock)
//lint -esym(1790, WidgetControllerData)

// While calling 'Symbol': Initializing the implict object parameter 'Type' (a non-const reference) with a non-lvalue
// (Deactivation only due to define FEATSTD_TYPEDEF_SHARED_POINTER in SESA source.)
//lint --esym(1793, FeatStd::MemoryManagement::SharedPointer*) Mantis ticket '7325'; TODO: remove this line if the Mantis ticket is solve


#endif   // __lint_deactivation_
