/* ***************************************************************************************
* FILE:          IMessageSystem.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IMessageSystem.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __IMessageSystem_H__
#define __IMessageSystem_H__

#include "View/MessagingDefines.h"
#include "View/DummyDefines.h"

//-------------------------------------------------------
#ifdef VARIANT_S_FTR_ENABLE_COURIERMESSAGING
#include <Courier/Foundation/ControllerComponent.h>
#define GETVIEWID_FROM_STR(str) Courier::ViewId(str)
#define POST_MESSAGE_IMPLEMENTATION(_Class_,_Message_) \
   void _Class_::postMsg(const _Message_& msg) \
   {\
      const_cast<_Message_&>(msg).Post();\
   }
//-------------------------------------------------------
#elif VARIANT_S_FTR_ENABLE_QT_MESSAGING
#include <QtCore/QObject>
#define GETVIEWID_FROM_STR(str) ::hmibase::view::ViewIdentifier(str)
#define POST_MESSAGE_IMPLEMENTATION(_Class_,_Message_)
//-------------------------------------------------------
#elif VARIANT_S_FTR_ENABLE_NO_MESSAGING
#define GETVIEWID_FROM_STR(str) ::hmibase::view::ViewIdentifier(str)
#define POST_MESSAGE_IMPLEMENTATION(_Class_,_Message_)  void _Class_::postMsg(const _Message_& msg) {}
//-------------------------------------------------------
#else
#error "build error: no messaging type like VARIANT_S_FTR_ENABLE_COURIERMESSAGING defined!"
#endif


#include "Trace/SurfaceInfoProvider.h" // only for shared ptr definition for SimTouchReqMsg message
#include "BaseContract/generated/BaseMsgs.h"
#include "BaseContract/generated/GadgetTypes.h"
#include "BaseContract/generated/GadgetMsgs.h"

#ifdef VARIANT_S_FTR_ENABLE_COURIERMESSAGING

template<typename MsgType, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
MsgType* newMessage(A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6, A7 arg7)
{
   return (COURIER_MESSAGE_NEW(MsgType)(arg1, arg2, arg3, arg4, arg5, arg6, arg7));
}


template<typename MsgType, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
MsgType* newMessage(A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6)
{
   return (COURIER_MESSAGE_NEW(MsgType)(arg1, arg2, arg3, arg4, arg5, arg6));
}


template<typename MsgType, typename A1, typename A2, typename A3, typename A4, typename A5>
MsgType* newMessage(A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5)
{
   return (COURIER_MESSAGE_NEW(MsgType)(arg1, arg2, arg3, arg4, arg5));
}


template<typename MsgType, typename A1, typename A2, typename A3, typename A4>
MsgType* newMessage(A1 arg1, A2 arg2, A3 arg3, A4 arg4)
{
   return (COURIER_MESSAGE_NEW(MsgType)(arg1, arg2, arg3, arg4));
}


template<typename MsgType, typename A1, typename A2, typename A3>
MsgType* newMessage(A1 arg1, A2 arg2, A3 arg3)
{
   return (COURIER_MESSAGE_NEW(MsgType)(arg1, arg2, arg3));
}


template<typename MsgType, typename A1, typename A2>
MsgType* newMessage(A1 arg1, A2 arg2)
{
   return (COURIER_MESSAGE_NEW(MsgType)(arg1, arg2));
}


template<typename MsgType, typename A1>
MsgType* newMessage(A1 arg1)
{
   return (COURIER_MESSAGE_NEW(MsgType)(arg1));
}


template<typename MsgType>
MsgType* newMessage()
{
   return (COURIER_MESSAGE_NEW(MsgType)());
}


#else // not courier

template<typename MsgType, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
MsgType* newMessage(A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6, A7 arg7)
{
   return new MsgType(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}


template<typename MsgType, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
MsgType* newMessage(A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6)
{
   return new MsgType(arg1, arg2, arg3, arg4, arg5, arg6);
}


template<typename MsgType, typename A1, typename A2, typename A3, typename A4, typename A5>
MsgType* newMessage(A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5)
{
   return new MsgType(arg1, arg2, arg3, arg4, arg5);
}


template<typename MsgType, typename A1, typename A2, typename A3, typename A4>
MsgType* newMessage(A1 arg1, A2 arg2, A3 arg3, A4 arg4)
{
   return new MsgType(arg1, arg2, arg3, arg4);
}


template<typename MsgType, typename A1, typename A2, typename A3>
MsgType* newMessage(A1 arg1, A2 arg2, A3 arg3)
{
   return new MsgType(arg1, arg2, arg3);
}


template<typename MsgType, typename A1, typename A2>
MsgType* newMessage(A1 arg1, A2 arg2)
{
   return new MsgType(arg1, arg2);
}


template<typename MsgType, typename A1>
MsgType* newMessage(A1 arg1)
{
   return new MsgType(arg1);
}


template<typename MsgType>
MsgType* newMessage()
{
   return new MsgType();
}


#endif // VARIANT_S_FTR_ENABLE_COURIERMESSAGING


#endif //guard
