/* ***************************************************************************************
* FILE:          Widget.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Widget.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "Widget.h"
#include "WidgetController.h"
#include <Courier/Visualization/View.h>
#include <CanderaWidget/Widget2D/Widget2D.h>
#include <CanderaWidget/Widget3D/Widget.h>

#include <hmi_trace_if.h>
#include <Trace/ToString.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_WIDGET
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/Widget.cpp.trc.h"
#endif

namespace hmibase {
namespace widget {

/*****************************************************************************/
Widget::IsInsideBoundingBox2DFct Widget::_fkt_IsInsideBoundingBox2DFunction = NULL;
bool Widget::_useDirtyRectangle = false;


/*****************************************************************************/
Widget::Widget()
{
   SetEnabledInternal(true);
   SetVisibleInternal(true);
}


/*****************************************************************************/
Widget::~Widget()
{
}


/*****************************************************************************/
WidgetController* Widget::GetDefaultController() const
{
   return NULL;
}


/*****************************************************************************/
void Widget::SetControllerId(ControllerIdType id)
{
   DelegateBase::SetControllerId(static_cast<WidgetController::DelegateWidget&>(*this), id);
}


/*****************************************************************************/
bool Widget::OnEvent(const WidgetControllerEvent& e)
{
   return DELEGATE_WIDGET_BOOL_FUNC(OnEvent(static_cast<WidgetController::DelegateWidget&>(*this), e));
}


/*****************************************************************************/
const BaseWidget2D* Widget::ToBaseWidget2D() const
{
   return NULL;
}


/*****************************************************************************/
BaseWidget2D* Widget::ToBaseWidget2D()
{
   return NULL;
}


/*****************************************************************************/
bool Widget::Is2D() const
{
   //this suboptimal implementation in the base class due to no Candera RTTI available here is overwritten in BaseWidget2D and BaseWidget3D
   const Candera::Widget2D* widget2D = dynamic_cast<const Candera::Widget2D*>(this);
   return widget2D != NULL;
}


/*****************************************************************************/
Candera::Node2D* Widget::GetNode2D() const
{
   //this suboptimal implementation in the base class due to no Candera RTTI available here is overwritten in BaseWidget2D and BaseWidget3D
   const Candera::Widget2D* widget2D = dynamic_cast<const Candera::Widget2D*>(this);
   return (widget2D != NULL) ? widget2D->GetNode() : NULL;
}


/*****************************************************************************/
const BaseWidget3D* Widget::ToBaseWidget3D() const
{
   return NULL;
}


/*****************************************************************************/
BaseWidget3D* Widget::ToBaseWidget3D()
{
   return NULL;
}


/*****************************************************************************/
bool Widget::Is3D() const
{
   //this suboptimal implementation in the base class due to no Candera RTTI available here is overwritten in BaseWidget2D and BaseWidget3D
   const Candera::Widget* widget3D = dynamic_cast<const Candera::Widget*>(this);
   return widget3D != NULL;
}


/*****************************************************************************/
Candera::Node* Widget::GetNode3D() const
{
   //this suboptimal implementation in the base class due to no Candera RTTI available here is overwritten in BaseWidget2D and BaseWidget3D
   const Candera::Widget* widget3D = dynamic_cast<const Candera::Widget*>(this);
   return (widget3D != NULL) ? widget3D->GetNode() : NULL;
}


/*****************************************************************************/
void Widget::OnChanged(FeatStd::UInt32 propertyId)
{
   if (GetParentView() != NULL)
   {
      ETG_TRACE_USR4_THR(("OnChanged prop=0x%x %s", propertyId, HMIBASE_TO_STRING_VW(this)));

      triggerUpdate();
   }
}


/*****************************************************************************/
bool Widget::IsPropertyVisible(FeatStd::UInt32 /*propertyId*/) const
{
   return true;
}


/*****************************************************************************/
void Widget::triggerUpdate()
{
   if (GetParentView() != NULL)
   {
      ETG_TRACE_USR4_THR(("TriggerUpdate %s", HMIBASE_TO_STRING_VW(this)));

      WakeUpAllRenderComponents();
      //Courier::Message* msg = COURIER_MESSAGE_NEW(TriggerComponentExecuteMsg)(static_cast<ComponentId>(ComponentType::View));
      //if (msg)
      //{
      //   msg->Post();
      //}
   }
}


/*****************************************************************************/
bool Widget::CloneFrom(const Candera::WidgetBase*, WidgetCloneHelper&)
{
   return false;
}


/*****************************************************************************/
bool Widget::PrepareForCloning()
{
   return true;
}


/*****************************************************************************/
void Widget::useDirtyRectangle(bool useDirtyRect)
{
   _useDirtyRectangle = useDirtyRect;
}


/*****************************************************************************/
bool Widget::isDirtyRectangleEnabled()
{
   return _useDirtyRectangle;
}


/*****************************************************************************/
const FeatStd::Char* Widget::GetLegacyName()
{
   return NULL;
}


/*****************************************************************************/
const FeatStd::Char* Widget::GetViewName() const
{
   return ((GetParentView() != NULL) && (GetParentView()->GetId().CStr() != NULL)) ? GetParentView()->GetId().CStr() : "<null>";
}


/*****************************************************************************/
void Widget::SetBoundingBoxCheckFunction(IsInsideBoundingBox2DFct fct)
{
   _fkt_IsInsideBoundingBox2DFunction = fct;
}


/*****************************************************************************/
bool Widget::IsVirtuallyTouched(FeatStd::UInt32 /*instanceID*/)
{
   return false;
}


/*****************************************************************************/
bool Widget::OnTouchGeneric(const Candera::CanderaObject& /*camera*/, const Candera::Vector2& /*pos*/, FeatStd::Float /*dist*/)
{
   return false;
};


/*****************************************************************************/
Candera::Rectangle Widget::GetWorldTouchableRectangle() const
{
   return Candera::Rectangle();
}


/*****************************************************************************/
FeatStd::UInt32 Widget::GetEffectiveTouchPriority() const
{
   return 0;
}


/*****************************************************************************/
hmibase::input::gesture::GestureListener::Gestures Widget::GetGestureList() const
{
   Gestures gestures;
   return gestures;
}


/*****************************************************************************/
bool Widget::IsEffectiveVisible() const
{
   return false;
}


/*****************************************************************************/
void Widget::SetFlagValue(FeatStd::UInt32 propertyId, size_t pos, bool value)
{
   ETG_TRACE_USR4_THR(("SetFlagValue prop=0x%x pos=%u value=%u %s",
                       propertyId, pos, value, HMIBASE_TO_STRING_VW(this)));

   //no change notification if property id is 0
   if (propertyId == 0)
   {
      _flags.set(pos, value);
   }
   else
   {
      //proceed only if value is changed
      if (value != _flags.test(pos))
      {
         _flags.set(pos, value);
         OnChanged(propertyId);
      }
   }
}


}
}
