/* ***************************************************************************************
* FILE:          DelegateBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DelegateBase.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#pragma once

namespace Candera {
class WidgetBase;
}


namespace hmibase {
namespace widget {

class WidgetController;
class WidgetControllerData;


class DelegateBase
{
   public:
      typedef FeatStd::Int16 ControllerIdType;

      static const FeatStd::UInt32 ControllerIdPropertyId = 0x8C23946E;

      DelegateBase();
      ~DelegateBase();

      ControllerIdType GetControllerId() const
      {
         return _controllerInfo != NULL ? _controllerInfo->ControllerId : ControllerIdType();
      }

      WidgetController* GetController() const
      {
         return _controllerInfo != NULL ? _controllerInfo->Controller : NULL;
      }

      WidgetControllerData* GetControllerData() const
      {
         return _controllerInfo != NULL ? _controllerInfo->ControllerData : NULL;
      }

      void SetControllerData(WidgetControllerData* data)
      {
         if (_controllerInfo != NULL)
         {
            _controllerInfo->ControllerData = data;
         }
      }

   protected:
      typedef ::Candera::WidgetBase DelegateWidget;

      void SetControllerId(DelegateWidget& widget, ControllerIdType id);
      void ClearController(DelegateWidget& widget);
      bool UpdateController(DelegateWidget& widget);

      struct ControllerInfo
      {
         ControllerIdType ControllerId;
         WidgetController* Controller;
         WidgetControllerData* ControllerData;

         ControllerInfo(ControllerIdType id = ControllerIdType()) : ControllerId(id), Controller(NULL), ControllerData(NULL)
         {
         }

         ~ControllerInfo()
         {
            Controller = NULL;
            ControllerData = NULL;
         }
      };

      ControllerInfo* _controllerInfo;

   private:
      DelegateBase(const DelegateBase&);
      DelegateBase& operator = (const DelegateBase&);

      void SetController(DelegateWidget& widget, WidgetController* controller);
};


}
}


#define CdaProperty_ControllerId()\
      CdaBindableProperty(ControllerId, ControllerIdType, GetControllerId, SetControllerId)\
      CdaDescription("Identifies the controller attached to this widget. \n -1 no controller is attached;\n 0 default controller for the class is attached (used for derived classes);\n 1..n id of a controller registered at start-up;")\
      CdaBindablePropertyEnd()

#define DELEGATE_WIDGET_ACTION(methodName)\
   if (_controllerInfo != NULL && (_controllerInfo->Controller != NULL))\
   {\
      _controllerInfo->Controller->methodName;\
   }

#define DELEGATE_WIDGET_BOOL_FUNC(methodName)\
   ((_controllerInfo != NULL) && (_controllerInfo->Controller != NULL) && _controllerInfo->Controller->methodName)
