/* ***************************************************************************************
* FILE:          TouchSession.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TouchSession.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(TouchHandling_TouchSession_h)
#define TouchHandling_TouchSession_h

#include <vector>
#include <Courier/Util/Vector.h>
#include "Courier/Messaging/MessageReferrer.h"

#include "View/CGI/TouchHandling/TouchSessionBase.h"
#include "TouchGestures/GestureHandler.h"
#include "TouchGestures/GestureListener.h"

namespace Courier {
class FrameworkWidget;
}


class GestureListener;
class WidgetComparerByTouchPriority;

namespace hmibase {
namespace input {

class TouchSession : public TouchSessionBase
{
   public:
      ///
      class Ref
      {
         public:
            Ref(TouchSession& ts) : mTs(&ts) {}
            const TouchSession& Get() const
            {
               return *mTs;
            }
         private:
            TouchSession* mTs;
      };

      ///
      TouchSession();

      ///
      virtual ~TouchSession();

      ///
      virtual void OnSessionStart(const Courier::TouchInfo& touchInfo);

      ///
      virtual void OnSessionStop(const Courier::TouchInfo& touchInfo);

      ///
      virtual bool OnMessage(const Courier::TouchMsg* touchMsgPtr);

      ///
      virtual bool OnMessage(const TouchAbort* msg);

      ///
      virtual bool OnMessage(const gesture::GestureTimerExpiredMsg* msg);

      /// A listener has to use that function the register itself in case it wants to receive Touch-events.
      bool Register(hmibase::input::gesture::GestureListener*);

      /// Deregister a listener from a TouchSession should be called in case of
      /// widget is not interested anymore in Touch-events or in case the widget is destroyed.
      bool Deregister(const hmibase::input::gesture::GestureListener* listener);

      ///
      void Cleanup();

      const Courier::Message* GetLegayTouchInfo() const
      {
         return _legacyTouchInfo;
      }

      ///
      size_t GetFrameworkWidgetCount() const
      {
         return _gestureListener.size();
      }

      virtual void printInfo();

      /// enables the deprecated gesture priority which does not use the widget priority but only the render order rank of the node
      static void enableDeprecatedGesturePriority(bool enable);

      static bool isDeprecatedGesturePriorityEnabled()
      {
         return _isDeprecatedGesturePriorityEnabled;
      }

   private:
      void registerGestures();
      typedef std::vector<hmibase::input::gesture::GestureListener*> GestureListenerList;
      GestureListenerList _gestureListener;

      Courier::Message* _legacyTouchInfo;

      /// enables the deprecated gesture priority which does not use the widget priority but only the render order rank of the node
      static bool _isDeprecatedGesturePriorityEnabled;
};


}
}


#endif
