/* ***************************************************************************************
* FILE:          WaylandEventHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WaylandEventHandler.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(InputHandling_Wayland_WaylandEventHandler_h)
#define InputHandling_Wayland_WaylandEventHandler_h

#include <View/CGI/InputHandling/Wayland/WaylandInc.h>

namespace Courier {
namespace InputHandling {
namespace Wayland {
/// @addtogroup COURIER_PLATFORM_WAYLAND
/// @{
class WaylandEventHandler
{
   public:
      ///
      static const struct wl_registry_listener* GetRegistryEventHandler();

      ///
      static const struct wl_seat_listener* GetSeatEventHandler();

      ///
      static const struct wl_pointer_listener* GetPointerEventHandler();

      ///
      static const struct wl_keyboard_listener* GetKeyboardEventHandler();

      ///
      static const struct wl_touch_listener* GetTouchEventHandler();

      /// For detailed interface description see Wayland client protocol documentation
      static void RegistryEventGlobal(void* data,
                                      struct wl_registry* registry,
                                      uint32_t name,
                                      const char* interface,
                                      uint32_t version);

      /// For detailed interface description see Wayland client protocol documentation
      static void RegistryEventGlobalRemove(void* data,
                                            struct wl_registry* registry,
                                            uint32_t name);

      /// For detailed interface description see Wayland client protocol documentation
      static void SeatEventCapabilities(void* data,
                                        struct wl_seat* seat,
                                        uint32_t caps);
      ///
      static void SeatHandleName(void* data,
                                 struct wl_seat* seat,
                                 const char* name);

      /// For detailed interface description see Wayland client protocol documentation
      static void PointerEventEnter(void* data,
                                    struct wl_pointer* pointer,
                                    uint32_t serial,
                                    struct wl_surface* surface,
                                    wl_fixed_t surface_x,
                                    wl_fixed_t surface_y);

      /// For detailed interface description see Wayland client protocol documentation
      static void PointerEventLeave(void* data,
                                    struct wl_pointer* pointer,
                                    uint32_t serial,
                                    struct wl_surface* surface);

      /// For detailed interface description see Wayland client protocol documentation
      static void PointerEventMotion(void* data,
                                     struct wl_pointer* pointer,
                                     uint32_t time,
                                     wl_fixed_t surface_x,
                                     wl_fixed_t surface_y);

      /// For detailed interface description see Wayland client protocol documentation
      static void PointerEventButton(void* data,
                                     struct wl_pointer* pointer,
                                     uint32_t serial,
                                     uint32_t time,
                                     uint32_t button,
                                     uint32_t state);

      /// For detailed interface description see Wayland client protocol documentation
      static void PointerEventAxis(void* data,
                                   struct wl_pointer* pointer,
                                   uint32_t time,
                                   uint32_t axis,
                                   wl_fixed_t value);
#if (WAYLAND_VERSION_MAJOR >=1 && WAYLAND_VERSION_MINOR >= 10)
      ///
      static void PointerHandleFrame(void* data,
                                     struct wl_pointer* pointer);

      ///
      static  void PointerHandleAxis_source(void* data,
                                            struct wl_pointer* pointer,
                                            uint32_t source);

      ///
      static void PointerHandleAxis_stop(void* data,
                                         struct wl_pointer* pointer,
                                         uint32_t time,
                                         uint32_t axis);

      ///
      static void PointerHandleAxis_discrete(void* data,
                                             struct wl_pointer* pointer,
                                             uint32_t axis,
                                             int32_t discrete);
#endif
      /// For detailed interface description see Wayland client protocol documentation
      static void KeyboardEventKeymap(void* data,
                                      struct wl_keyboard* keyboard,
                                      uint32_t format,
                                      int32_t fd,
                                      uint32_t size);

      /// For detailed interface description see Wayland client protocol documentation
      static void KeyboardEventEnter(void* data,
                                     struct wl_keyboard* keyboard,
                                     uint32_t serial,
                                     struct wl_surface* surface,
                                     struct wl_array* keys);

      /// For detailed interface description see Wayland client protocol documentation
      static void KeyboardEventLeave(void* data,
                                     struct wl_keyboard* keyboard,
                                     uint32_t serial,
                                     struct wl_surface* surface);

      /// For detailed interface description see Wayland client protocol documentation
      static void KeyboardEventKey(void* data,
                                   struct wl_keyboard* keyboard,
                                   uint32_t serial,
                                   uint32_t time,
                                   uint32_t key,
                                   uint32_t state);

      /// For detailed interface description see Wayland client protocol documentation
      static void KeyboardEventModifiers(void* data,
                                         struct wl_keyboard* keyboard,
                                         uint32_t serial,
                                         uint32_t mods_depressed,
                                         uint32_t mods_latched,
                                         uint32_t mods_locked,
                                         uint32_t group);
#if (WAYLAND_VERSION_MAJOR >=1 && WAYLAND_VERSION_MINOR >= 6)
      static void KeyboardHandleRepeatInfo(void* data,
                                           struct wl_keyboard* keyboard,
                                           int32_t rate,
                                           int32_t delay);
#endif

      /// For detailed interface description see Wayland client protocol documentation
      static void TouchEventDown(void* data,
                                 struct wl_touch* touch,
                                 uint32_t serial,
                                 uint32_t time,
                                 struct wl_surface* surface,
                                 int32_t id,
                                 wl_fixed_t x,
                                 wl_fixed_t y);

      /// For detailed interface description see Wayland client protocol documentation
      static void TouchEventUp(void* data,
                               struct wl_touch* touch,
                               uint32_t serial,
                               uint32_t time,
                               int32_t id);

      /// For detailed interface description see Wayland client protocol documentation
      static void TouchEventMotion(void* data,
                                   struct wl_touch* touch,
                                   uint32_t time,
                                   int32_t id,
                                   wl_fixed_t x,
                                   wl_fixed_t y);

      /// For detailed interface description see Wayland client protocol documentation
      static void TouchEventFrame(void* data,
                                  struct wl_touch* touch);

      /// For detailed interface description see Wayland client protocol documentation
      static void TouchEventCancel(void* data,
                                   struct wl_touch* touch);

#if (WAYLAND_VERSION_MAJOR >=1 && WAYLAND_VERSION_MINOR >= 13)
      static void TouchEventShape(void *data,
                                  struct wl_touch *wl_touch,
                                  int32_t id,
                                  wl_fixed_t major,
                                  wl_fixed_t minor);

      static void TouchEventOrientation(void *data,
                                        struct wl_touch *wl_touch,
                                        int32_t id,
                                        wl_fixed_t orientation);

#endif

};


}
}


}

#endif
