/* ***************************************************************************************
* FILE:          WaylandContext.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WaylandContext.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(InputHandling_Wayland_WaylandContext_h)
#define InputHandling_Wayland_WaylandContext_h
//lint -sem(Courier::InputHandling::Wayland::WaylandContext::Destroy,cleanup)

#include "lint_deactivation.h"
#include <Courier/Platform/Types.h>
#include <View/CGI/InputHandling/Wayland/WaylandInc.h>
#include <View/CGI/InputHandling/Wayland/WLSeat.h>
#include <list>

namespace Courier {
namespace InputHandling {
namespace Wayland {

class WaylandEventHook;
class WaylandEventHandler;

/** Holds the current status of the wayland communication */
class WaylandContext
{
   public:
      ///
      WaylandContext();

      ///
      virtual ~WaylandContext();

      /** Initializes the input handling specific wayland context.
          @param display Wayland display handle.
          @param data User specific data, channelled to user specific eventhandler.
          @param eventHook User specific event handling.
          @return <em>true</em>, if initialization was successful,
                  <em>false</em>, otherwise.*/
      bool Init(wl_display* display, void* data, WaylandEventHook* eventHook = 0);

      ///
      struct wl_display* GetDisplay() const
      {
         return mDisplay;
      }

      ///
      struct wl_registry* GetRegistry() const
      {
         return mRegistry;
      }

      /** */
      struct wl_event_queue* GetEventQueue() const
      {
         return mEventQueue;
      }

      ///
      void* GetData() const
      {
         return mData;
      }

      ///
      WaylandEventHook* GetEventHook() const
      {
         return mEventHook;
      }

      ///
      void SetEventHook(WaylandEventHook* eventHook)
      {
         mEventHook = eventHook;
      }

      ///
      bool IsInitialized() const
      {
         return mInitialized;
      }

   protected:
      ///
      void Destroy();

   private:
      friend class WaylandEventHandler;

      struct wl_display* mDisplay;
      struct wl_registry* mRegistry;
      struct wl_event_queue* mEventQueue;
      void* mData;
      WaylandEventHook* mEventHook;
      bool mInitialized;

      std::list<WLSeat*> _wlSeatList;

      void AddWlSeat(WLSeat* pWlSeat)
      {
         _wlSeatList.push_back(pWlSeat);
      }
      std::list<WLSeat*>* GetWLSeatList()
      {
         return &_wlSeatList;
      }
};


}
}


}

#endif
