/* ***************************************************************************************
* FILE:          GenericConsoleInputHandler.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  GenericConsoleInputHandler.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "lint_deactivation.h"
#include "GenericConsoleInputHandler.h"

#include <Courier/Foundation/FoundationMsgs.h>
#include <Courier/Platform/MessageFactory.h>
#include <Courier/Diagnostics/Log.h>

#include <errno.h>

#include "hmi_trace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW_INPUT
#include "trcGenProj/Header/GenericConsoleInputHandler.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

namespace Courier {
namespace InputHandling {
namespace Generic {
// ------------------------------------------------------------------------
bool GenericConsoleInputHandler::Listen()
{
   bool lRc = true;
   Message* lMsg = cDoDefaultHandling;

   // Currently only blocking mode is available with this input handler
   FEATSTD_DEBUG_ASSERT(InputHandlerMode::Blocking == GetMode());

   // Check if mode is set to blocking
   lRc = lRc && (InputHandlerMode::Blocking == GetMode());
   if (lRc)
   {
      // Read event queue
      Int lKey = ::getchar();

      // Call input handler hook, if available
      Hook* lHook = reinterpret_cast<Hook*>(GetEventHook());
      if (0 != lHook)
      {
         lMsg = lHook->OnEvent(lKey);
      }

      // Event is not handled by event hook, send terminal input (ignoring control keys)
      if (DoDefaultHandling(lMsg))
      {
         if ((lKey > 0x1F) && (lKey < 0x7F))
         {
            ETG_TRACE_USR4_THR(("Key '%c' pressed!", lKey));
            lMsg = COURIER_MESSAGE_NEW(KeyDownMsg)(static_cast<KeyCode>(lKey));
         }
      }
   }
   else
   {
      ETG_TRACE_ERR_THR(("Input handler started in invalid mode, terminating input handling..."));
   }

   if (lRc)
   {
      // If event yielded a valid message, post it (if not, it is ignored)
      Post(lMsg);
   }

   return (lRc && (!TerminateInputHandler(lMsg)));
}


// ------------------------------------------------------------------------
void GenericConsoleInputHandler::SetMode(InputHandlerMode::Enum mode)
{
   FEATSTD_PANIC_IF(InputHandlerMode::Polling == mode, "Polling (non-blocking) mode not supported!");
}


}
}


}
