/* ***************************************************************************************
* FILE:          AppEnvironmentPlatform.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AppEnvironmentPlatform.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(AppPlatform_Impl_AppEnvironment_h)
#define AppPlatform_Impl_AppEnvironment_h

#include "View/CGI/GuiBase/AppEnvironment.h"


#include <View/CGI/InputHandling/Wayland/WaylandInputHandler.h>
#include "View/CGI/InputHandling/WindowInputEventHook.h"

// Test define for 2nd display support
//#define HAS_2ND_DISPLAY 1

// Test define for terminal input support
//#define HAS_TERMINAL_INPUT

class IApplicationSettings;

namespace AppPlatform {
namespace Impl {

class AppEnvironment : public AppPlatform::AppEnvironment
{
      typedef AppPlatform::AppEnvironment Base;

   public:
      explicit AppEnvironment(const IApplicationSettings& projSettings);

   private:
      void SetupTraceForFramework(const IApplicationSettings& settings);
      WindowInputEventHook mWindowInputEventHook;
      Courier::InputHandling::Wayland::WaylandInputHandler mMainWindowInputHandler;

#if defined(HAS_2ND_DISPLAY)
      Courier::InputHandling::Wayland::WaylandInputHandler m2ndWindowInputHandler;
#endif

   protected:
      virtual bool BeforeInputContextSetup();
      virtual bool Cleanup(const std::vector<std::string>& cAssetFileNames);
      virtual void SetupInputHandler(int);
      virtual void SetupInputThread(int);
      virtual bool SyncWindowCreation();
      virtual void SetupTouchPreprocessor();
      virtual Candera::AssetRepository* GetAssetRepo(const char* assetFileName);
};


}
}


#endif
