/* ***************************************************************************************
* FILE:          ICgiApp.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ICgiApp.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef ICGIAPP_H
#define ICGIAPP_H

namespace AppPlatform {
class AppEnvironment;
}

namespace asf {
namespace core {
class BaseComponent;
}
}


class ICgiApp
{
   public:
      ICgiApp() {};
      virtual ~ICgiApp() {};
      virtual bool Init(AppPlatform::AppEnvironment*, ::asf::core::BaseComponent* baseComponent = 0) = 0;
      virtual bool Run() = 0;
      virtual bool Finalize() = 0;
};


#endif
