/* ***************************************************************************************
* FILE:          CgiApplicationBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CgiApplicationBase.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_CGI_ApplicationBase_h_)
#define _CGI_ApplicationBase_h_

#include "View/CGI/GuiBase/ICgiApp.h"

#include "View/CGI/CgiExtensions/AppViewHandler.h"
#include "View/CGI/CgiExtensions/CloseOnTouchSession.h"
#include <View/CGI/CgiExtensions/ViewComponent.h>

#include "HMIAppCtrl/Proxy/ProxyHandler.h"

#include "View/CGI/CgiExtensions/Renderer.h"

#include "Trace/GetViewMetaInfo.h"

#ifndef WIN32
class SyncBlockConsumer;
#endif

namespace AppPlatform {
class AppEnvironment;
}


namespace Focus {
class FManagerConfigurator;
}


class CgiApplicationBase : public ICgiApp
{
   public:
      CgiApplicationBase(const std::vector<std::string>& cAssetFileNames, hmibase::services::hmiappctrl::ProxyHandler& hmiAppCtrlProxyHandler);

      virtual ~CgiApplicationBase();

      virtual bool Init(AppPlatform::AppEnvironment* appEnvironment, ::asf::core::BaseComponent* baseComponent = 0);

      virtual bool Run();

      virtual bool Finalize();

      static bool PostMsg(Courier::Message* msg);

      void setMaxFPSRenderConfiguration();
      void setDefaultRenderConfiguration();

#ifdef FEATSTD_MEMORYPOOL_ENABLED
      void onDestructPoolsCallback();
#endif

   protected:
      void terminateThreads();

      bool setupMsgReceiverRenderer();

      bool setupMsgReceiverView();

      virtual bool setupMsgReceiverSM() = 0;

      Courier::IViewHandler& GetViewHandler()
      {
         return mViewHandler;
      }

      virtual Courier::ViewFactory* getViewFactory() = 0;
      virtual Courier::ViewControllerFactory* getViewControllerFactory() = 0;

      virtual void setupRenderTargetConfiguration(Courier::RenderConfiguration&) = 0;

      virtual bool initializeFocusManager();
      virtual bool finalizeFocusManager();
      virtual Focus::FManagerConfigurator* createFocusManagerConfigurator();

      Courier::ComponentMessageReceiver   mMsgReceiver;
      AppViewHandler&    mViewHandler;
      hmibase::view::ViewComponent        mViewComponent;
      Courier::RenderComponent            mRenderComponent;
      hmibase::input::CloseOnTouchSession   mDemoTouchSession;

      ::hmibase::trace::GetViewMetaInfo   _viewMetaInfoCollector;

      hmibase::view::Renderer                   mRenderer;

      AppPlatform::AppEnvironment*        mAppEnvironment;
      std::vector<std::string>            mAssetFileNames;

      hmibase::services::hmiappctrl::ProxyHandler& _hmiAppCtrlProxyHandler;
      Focus::FManagerConfigurator*        _focusManagerConfigurator;

   private:
      HMIBASE_UNCOPYABLE(CgiApplicationBase)
};


#endif
