/* ***************************************************************************************
* FILE:          CourierMsgTracing.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CourierMsgTracing.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include <Courier/Base.h>
#include "BaseContract/generated/BaseTypes.h"
#include "AppUtils/Timer.h"
#include "Trace/SurfaceInfoProvider.h"
#include "View/CGI/TouchHandling/TouchSession.h"
#include "Courier/Visualization/IViewHandler.h"
#include "hmibase/util/StringUtils.h"
#include "AppUtils/HmiMacros.h"
#include <CanderaPlatform/Device/Common/Base/DevicePackageDescriptor.h>

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)

namespace FeatStd {
#if 0
template<> ::FeatStd::UInt32 StringBufferAppender< Courier::TouchInfo >::Append(::FeatStd::StringBuffer& stringBuffer, Courier::TouchInfo const& object)
{
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::Courier::TouchInfo { ");
   tcharCount += stringBuffer.Append("x = ");
   tcharCount += stringBuffer.AppendObject(object.mX);
   tcharCount += stringBuffer.Append("y = ");
   tcharCount += stringBuffer.AppendObject(object.mY);
   tcharCount += stringBuffer.Append("PointerId = ");
   tcharCount += stringBuffer.AppendObject(object.mPointerId);
   tcharCount += stringBuffer.Append("SourceId = ");
   tcharCount += stringBuffer.AppendObject(object.mSourceId);
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}


template<> ::FeatStd::UInt32 StringBufferAppender< hmibase::input::TouchSession::Ref >::Append(::FeatStd::StringBuffer& stringBuffer, hmibase::input::TouchSession::Ref const& object)
{
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::hmibase::input::TouchSession::Ref { ");
   tcharCount += stringBuffer.Append("WidgetCount = ");
   tcharCount += stringBuffer.AppendObject(object.Get().GetFrameworkWidgetCount());
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}


#endif

template<> ::FeatStd::UInt32 StringBufferAppender< hmibase::input::gesture::GestureEvent::GestureType >::Append(::FeatStd::StringBuffer& stringBuffer, hmibase::input::gesture::GestureEvent::GestureType const& object)
{
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::hmibase::input::gesture::GestureEvent::GestureType { ");
   switch (object)
   {
      case hmibase::input::gesture::GestureEvent::GT_None:
         tcharCount += stringBuffer.Append("GT_NONE");
         break;
      case hmibase::input::gesture::GestureEvent::GT_DragNudge:
         tcharCount += stringBuffer.Append("GT_DragNudge");
         break;
      case hmibase::input::gesture::GestureEvent::GT_LegacyTouch:
         tcharCount += stringBuffer.Append("GT_LegacyTouch");
         break;
      case hmibase::input::gesture::GestureEvent::GT_PinchSpread:
         tcharCount += stringBuffer.Append("GT_PinchSpread");
         break;
      case hmibase::input::gesture::GestureEvent::GT_PressHoldRepeatTap:
         tcharCount += stringBuffer.Append("GT_PressHoldRepeatTap");
         break;
      case hmibase::input::gesture::GestureEvent::GT_RawTouchData:
         tcharCount += stringBuffer.Append("GT_RawTouchData");
         break;
      case hmibase::input::gesture::GestureEvent::GT_Rotate:
         tcharCount += stringBuffer.Append("GT_Rotate");
         break;
      case hmibase::input::gesture::GestureEvent::GT_SwipeFling:
         tcharCount += stringBuffer.Append("GT_SwipeFling");
         break;
      default:
         break;
   }
   tcharCount += stringBuffer.Append(" }");

   return tcharCount;
}


template<> ::FeatStd::UInt32 StringBufferAppender< hmibase::input::gesture::GestureEvent::GestureState >::Append(::FeatStd::StringBuffer& stringBuffer, hmibase::input::gesture::GestureEvent::GestureState const& object)
{
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::hmibase::input::gesture::GestureEvent::GestureState { ");
   switch (object)
   {
      case hmibase::input::gesture::GestureEvent::ET_ABORT:
         tcharCount += stringBuffer.Append("ET_ABORT");
         break;
      case hmibase::input::gesture::GestureEvent::ET_DT_START:
         tcharCount += stringBuffer.Append("ET_DT_START");
         break;
      case hmibase::input::gesture::GestureEvent::ET_END:
         tcharCount += stringBuffer.Append("ET_END");
         break;
      case hmibase::input::gesture::GestureEvent::ET_HOLD:
         tcharCount += stringBuffer.Append("ET_HOLD");
         break;
      case hmibase::input::gesture::GestureEvent::ET_INITIATE:
         tcharCount += stringBuffer.Append("ET_INITIATE");
         break;
      case hmibase::input::gesture::GestureEvent::ET_MOVE:
         tcharCount += stringBuffer.Append("ET_MOVE");
         break;
      case hmibase::input::gesture::GestureEvent::ET_None:
         tcharCount += stringBuffer.Append("ET_None");
         break;
      case hmibase::input::gesture::GestureEvent::ET_RAW_DATA:
         tcharCount += stringBuffer.Append("ET_RAW_DATA");
         break;
      case hmibase::input::gesture::GestureEvent::ET_REPEAT:
         tcharCount += stringBuffer.Append("ET_REPEAT");
         break;
      case hmibase::input::gesture::GestureEvent::ET_START:
         tcharCount += stringBuffer.Append("ET_START");
         break;
      default:
         break;
   }
   tcharCount += stringBuffer.Append(" }");

   return tcharCount;
}


template<> ::FeatStd::UInt32 StringBufferAppender< hmibase::input::gesture::GestureEvent::Direction >::Append(::FeatStd::StringBuffer& stringBuffer, hmibase::input::gesture::GestureEvent::Direction const& object)
{
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::hmibase::input::gesture::GestureEvent::GestureState { ");
   switch (object)
   {
      case hmibase::input::gesture::GestureEvent::DIR_2D:
         tcharCount += stringBuffer.Append("DIR_2D");
         break;
      case hmibase::input::gesture::GestureEvent::DIR_ANTICLOCKWISE:
         tcharCount += stringBuffer.Append("DIR_ANTICLOCKWISE");
         break;
      case hmibase::input::gesture::GestureEvent::DIR_CLOCKWISE:
         tcharCount += stringBuffer.Append("DIR_CLOCKWISE");
         break;
      case hmibase::input::gesture::GestureEvent::DIR_HORIZONTAL:
         tcharCount += stringBuffer.Append("DIR_HORIZONTAL");
         break;
      case hmibase::input::gesture::GestureEvent::DIR_NONE:
         tcharCount += stringBuffer.Append("DIR_NONE");
         break;
      case hmibase::input::gesture::GestureEvent::DIR_VERTICAL:
         tcharCount += stringBuffer.Append("DIR_VERTICAL");
         break;
      default:
         break;
   }
   tcharCount += stringBuffer.Append(" }");

   return tcharCount;
}


template<> ::FeatStd::UInt32 StringBufferAppender< Util::Timer* >::Append(::FeatStd::StringBuffer& stringBuffer, Util::Timer* const& object)
{
   //the timer can be owned by a widget or some other component and destroyed after TimerExpireMsg is posted so the pointer received may not be not valid anymore
   //don't use the pointer for anything else than printing its address or comparing it with another pointer

   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::Util::Timer* { ");
   tcharCount += stringBuffer.Append("Pointer = ");
   tcharCount += stringBuffer.AppendPointer(object);
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}


template<> ::FeatStd::UInt32 StringBufferAppender< Util::Timer::Status >::Append(::FeatStd::StringBuffer& stringBuffer, Util::Timer::Status const& object)
{
   ::FeatStd::UInt32 tcharCount = 0;
   switch (object)
   {
      case Util::Timer::Stopped:
         tcharCount += stringBuffer.Append("Stopped");
         break;
      case Util::Timer::Running:
         tcharCount += stringBuffer.Append("Running");
         break;
      case Util::Timer::Paused:
         tcharCount += stringBuffer.Append("Paused");
         break;
      case Util::Timer::Expired:
         tcharCount += stringBuffer.Append("Expired");
         break;
      default:
         break;
   }
   return tcharCount;
}


template<> ::FeatStd::UInt32 StringBufferAppender< ::hmibase::trace::SurfaceInfoProvider >::Append(FeatStd::StringBuffer& stringBuffer, ::hmibase::trace::SurfaceInfoProvider const& object)
{
   PARAM_UNUSED(object);

   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::SurfaceInfoProvider* { ");
   tcharCount += stringBuffer.Append("todo");
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}


template<> ::FeatStd::UInt32 StringBufferAppender< std::vector<FeatStd::Int32> >::Append(FeatStd::StringBuffer& stringBuffer, std::vector<FeatStd::Int32> const& object)
{
   PARAM_UNUSED(object);

   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("std::vector<FeatStd::Int32> { ");
   for (unsigned int i = 0; i < object.size(); ++i)
   {
      tcharCount += stringBuffer.AppendObject(object[i]);
   }
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}


template<> ::FeatStd::UInt32 StringBufferAppender< std::vector<FeatStd::UInt32> >::Append(FeatStd::StringBuffer& stringBuffer, std::vector<FeatStd::UInt32> const& object)
{
   PARAM_UNUSED(object);

   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("std::vector<FeatStd::UInt32> { ");
   for (unsigned int i = 0; i < object.size(); ++i)
   {
      tcharCount += stringBuffer.AppendObject(object[i]);
   }
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}


template<> ::FeatStd::UInt32 StringBufferAppender< Candera::DevicePackageDescriptor::UnitCategory>::Append(::FeatStd::StringBuffer& stringBuffer, Candera::DevicePackageDescriptor::UnitCategory const& object)
{
   ::FeatStd::UInt32 tcharCount = 0;
   switch (object)
   {
      case Candera::DevicePackageDescriptor::DisplayTarget3D:
         tcharCount += stringBuffer.Append("Candera::DevicePackageDescriptor::DisplayTarget3D");
         break;
      case Candera::DevicePackageDescriptor::DisplayTarget2D:
         tcharCount += stringBuffer.Append("Candera::DevicePackageDescriptor::DisplayTarget2D");
         break;
      case Candera::DevicePackageDescriptor::Mixed2D3DDisplayTarget:
         tcharCount += stringBuffer.Append("Candera::DevicePackageDescriptor::Mixed2D3DDisplayTarget");
         break;
      case Candera::DevicePackageDescriptor::OffscreenTarget3D:
         tcharCount += stringBuffer.Append("Candera::DevicePackageDescriptor::OffscreenTarget3D");
         break;
      case Candera::DevicePackageDescriptor::OffscreenTarget2D:
         tcharCount += stringBuffer.Append("Candera::DevicePackageDescriptor::OffscreenTarget2D");
         break;
      case Candera::DevicePackageDescriptor::Mixed2D3DOffscreenTarget:
         tcharCount += stringBuffer.Append("Candera::DevicePackageDescriptor::Mixed2D3DOffscreenTarget");
         break;
      case Candera::DevicePackageDescriptor::OffscreenTarget2Dto3D:
         tcharCount += stringBuffer.Append("Candera::DevicePackageDescriptor::OffscreenTarget2Dto3D");
         break;
      case Candera::DevicePackageDescriptor::OffscreenTarget3Dto2D:
         tcharCount += stringBuffer.Append("Candera::DevicePackageDescriptor::OffscreenTarget3Dto2D");
         break;
      case Candera::DevicePackageDescriptor::ExternalSource:
         tcharCount += stringBuffer.Append("Candera::DevicePackageDescriptor::ExternalSource");
         break;
      case Candera::DevicePackageDescriptor::CustomObject:
         tcharCount += stringBuffer.Append("Candera::DevicePackageDescriptor::CustomObject");
         break;
      default:
         tcharCount += stringBuffer.Append("##unknown##");
         break;
   }
   return tcharCount;
}


}
#endif
