/* ***************************************************************************************
* FILE:          CourierMessageMapTraceOut.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CourierMessageMapTraceOut.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "lint_deactivation.h"
#include "CourierMessageMapTraceOut.h"
#include "Courier/Messaging/Message.h"
#include "hmibase/util/StringUtils.h"
#include "AppUtils/HmiMacros.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_COURIER_MSG_OUT
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/CourierMessageMapTraceOut.cpp.trc.h"
#endif

void CourierMessageMapTraceOut::printOutgoing(const Courier::Message& msg, const char* file, unsigned int line, unsigned int traceclass)
{
   if (traceclass == 0)
   {
      ETG_TRACE_ERR_THR(("[%16s] line=%4d file=%s: No trace class defined", hmibase::trace::getAppName().c_str(), line, file));
   }
   else
   {
      ETG_TRACE_USR1_THR_DCL((traceclass, "@MP:<%d>[%16s]: msg post line=%4d, fkt:'%s'", ETG_CENUM(CourierComponent, getComponent(traceclass)), hmibase::trace::getAppName().c_str(), line, msg.GetName()));

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
      ETG_TRACE_USR4_THR_DCL((traceclass, "\t payload: '%s'", getMessagePayload(msg).c_str()));
      /// FeatStd::Internal::FixedSizeString<500> buf;
      /// FeatStd::FixedSizeStringBuffer<500> strBuf(buf);
      /// strBuf.AppendObject(msg);
      /// ETG_TRACE_USR4_THR_DCL((traceclass, "\t payload: '%s'", buf.CStr()));
#endif
   }
}


void CourierMessageMapTraceOut::printError(const char* file, unsigned int line, unsigned int traceclass)
{
   PARAM_UNUSED(file);
   PARAM_UNUSED(traceclass);

   ETG_TRACE_ERR_THR(("@MP:<%d>[%16s]: outcoming post failed line=%4d", ETG_CENUM(CourierComponent, getComponent(traceclass)), hmibase::trace::getAppName().c_str(), line));
}
