/* ***************************************************************************************
* FILE:          CourierMessageMapTraceIn.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CourierMessageMapTraceIn.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "lint_deactivation.h"
#include "Courier/Messaging/Message.h"
#include "hmi_trace_if.h"
#include "CourierMessageMapTraceIn.h"

#define HMI_COURIER_PAYLOAD_L1 240
#define HMI_COURIER_PAYLOAD_L2 (HMI_COURIER_PAYLOAD_L1 + HMI_COURIER_PAYLOAD_L1)
#define HMI_COURIER_PAYLOAD_L3 (HMI_COURIER_PAYLOAD_L2 + HMI_COURIER_PAYLOAD_L1)

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_COURIER_MSG_IN
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/CourierMessageMapTraceIn.cpp.trc.h"
#endif

void CourierMessageMapTraceIn::printIncoming(const Courier::Message& msg, const char* file, unsigned int line, unsigned int traceclass)
{
   if (traceclass == 0)
   {
      ETG_TRACE_ERR_THR(("[%16s] line=%4d file=%s: No trace class defined", hmibase::trace::getAppName().c_str(), line, file));
   }
   else
   {
      ETG_TRACE_USR1_THR_DCL((traceclass, "@MP:<%d>[%16s]: incoming msg line=%4d, fkt:'%s'", ETG_CENUM(CourierComponent, getComponent(traceclass)), hmibase::trace::getAppName().c_str(), line, msg.GetName()));

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
      std::string payload; // max len payload can be 1000 chars
      ETG_TRACE_USR4_THR_DCL((traceclass, "\t payload 1: '%s'", (payload = getMessagePayload(msg)).c_str()));
      if (payload.length() > HMI_COURIER_PAYLOAD_L1)
      {
         ETG_TRACE_USR4_THR_DCL((traceclass, "\t payload 2: '%s'", &payload.at(HMI_COURIER_PAYLOAD_L1)));
      }
      if (payload.length() > HMI_COURIER_PAYLOAD_L2)
      {
         ETG_TRACE_USR4_THR_DCL((traceclass, "\t payload 3: '%s'", &payload.at(HMI_COURIER_PAYLOAD_L2)));
      }
      if (payload.length() > HMI_COURIER_PAYLOAD_L3)
      {
         ETG_TRACE_USR4_THR_DCL((traceclass, "\t payload 4: '%s'", &payload.at(HMI_COURIER_PAYLOAD_L3)));
      }
#endif
   }
}

