/* ***************************************************************************************
* FILE:          DeductResult.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DeductResult.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef CIT_DEDUCTRESULT_H
#define CIT_DEDUCTRESULT_H

namespace Cit {
namespace DeductResult {
enum Enum
{
   /**
   * An error occurred.
   */
   DeductError = 0,
   /**
   * No error occurred (no state change, no action called and no internal or external transition).
   */
   DeductOk,
   /**
   * Internal transition (without state changed) without action call (an internal transition has been triggered but no action has been called).
   */
   InternalTransition_NoActionCalled,
   /**
   * Internal transition (without state changed) with action call (an internal transition has been triggered and at least one action has been called).
   */
   InternalTransition_ActionCalled,
   /**
   * External transition (state changed) without action call (a state has been changed and no action has been called).
   */
   ExternalTransition_NoActionCalled,
   /**
   * External transition (state changed) with action call (a state has been changed and at least one action has been called).
   */
   ExternalTransition_ActionCalled
};


}
}


#endif
