/* ***************************************************************************************
* FILE:          ViewScene2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ViewScene2D.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef HMIBASE_VIEWSCENE2D_H
#define HMIBASE_VIEWSCENE2D_H

#include "ViewScene.hpp"
#include <Courier/Visualization/ViewScene2D.h>

namespace hmibase {
namespace view {

class ViewScene2D : public ViewSceneBase<Courier::ViewScene2D, Candera::Camera2D>
{
      typedef ViewSceneBase<Courier::ViewScene2D, Candera::Camera2D> Base;

   public:
      ViewScene2D(bool managed = false);
      virtual ~ViewScene2D();
};


}
HMIBASE_DEPRECATED_TYPE_ALIAS(ViewScene2D, view::ViewScene2D);
}


#endif // HMIBASE_VIEWSCENE2D_H
