/* ***************************************************************************************
* FILE:          ViewProfilehandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ViewProfilehandler.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef VIEWPROFILEHANDLER_H_
#define VIEWPROFILEHANDLER_H_

#include "Courier/Visualization/VisualizationMsgs.h"
#include "Courier/Visualization/ViewHandler.h"
#include "BaseContract/generated/BaseMsgs.h"
#include "View/CGI/CgiExtensions/CourierMessageMapper.h"
#include "View/CGI/CgiExtensions/HMIRenderViewVisitor.h"
#include "View/CGI/CgiExtensions/SceneTransitionMediator.h"
#include "View/CGI/CgiExtensions/IViewMap.h"

#include "hmi_trace_if.h"

namespace hmibase {
   namespace view {
      class ViewProfilehandler
      {
      public:
         ViewProfilehandler();
         explicit ViewProfilehandler(Courier::ViewHandler* viewhandler, HMIRenderViewVisitor* hmirenderviewvisitor);
         virtual ~ViewProfilehandler();

         static void SetViewMap(hmibase::view::IViewMap* viewMap)
         {
            s_viewMap = viewMap;
         }

         COURIER_MSG_MAP_BEGIN(TR_CLASS_HMI_FW)
            ON_COURIER_MESSAGE(ExtendedViewReqMsg)
            ON_COURIER_MESSAGE(ProfileSwitchMsg)
            COURIER_MSG_MAP_END()

      private:

         bool onCourierMessage(const ExtendedViewReqMsg& msg);
         bool onCourierMessage(const ProfileSwitchMsg& msg);
         bool ShowView(const Courier::ViewId& viewID);
         bool HideView(const Courier::ViewId& viewID);
         static unsigned int s_currentprofile;
         Courier::ViewHandler* _viewhandler;
         HMIRenderViewVisitor* _hmirenderviewvisitor;
         SceneTransitionMediator _sceneTransitionMediator;

         friend unsigned int getCurrentViewProfile(void);

         static hmibase::view::IViewMap* s_viewMap;
      };

   }
}
#endif /* PROFILEHANDLER_H_ */
