/* ***************************************************************************************
* FILE:          ViewInfo.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ViewInfo.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "ViewInfo.h"
#include "ViewControllerBase.h"

#include <hmi_trace_if.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_VIEW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ViewInfo.cpp.trc.h"
#endif


namespace Courier {
class ViewController;
}


namespace hmibase {
namespace view {

/*****************************************************************************/
Courier::ViewController* CreateDefaultViewController(const Courier::ViewId&)
{
   return FEATSTD_NEW(DefaultViewController);
}


/*****************************************************************************/
Courier::ViewId ViewInfoManager::GetViewId(const FeatStd::Char* viewName)
{
   if ((viewName != NULL) && IsInitialized())
   {
      const ViewInfo* viewInfo = GetViewInfo(viewName);
      if (viewInfo != NULL)
      {
         return viewInfo->GetViewId();
      }
   }
   return Courier::ViewId();
}


/*****************************************************************************/
Courier::ViewId ViewInfoManager::GetViewId(FeatStd::UInt32 viewNameHash)
{
   if (IsInitialized())
   {
      const ViewInfo* viewInfo = GetViewInfo(viewNameHash);
      if (viewInfo != NULL)
      {
         return viewInfo->GetViewId();
      }
   }
   return Courier::ViewId();
}


/*****************************************************************************/
const ViewInfo* ViewInfoManager::GetViewInfo(const FeatStd::Char* viewName)
{
   if ((viewName != NULL) && IsInitialized())
   {
      FeatStd::UInt32 viewNameHash = Courier::ViewId(viewName).GetHashId().HashValue();
      const ViewInfo* viewInfo = GetViewInfo(viewNameHash);
      return viewInfo;
   }
   return NULL;
}


/*****************************************************************************/
const ViewInfo* ViewInfoManager::GetViewInfo(FeatStd::UInt32 viewNameHash)
{
   return GetViewInfoFunc() != NULL ? GetViewInfoFunc()(viewNameHash) : NULL;
}


/*****************************************************************************/
const ViewInfo* ViewInfoManager::GetViewInfo(const Courier::ViewId& viewId)
{
   return GetViewInfo(viewId.GetHashId().HashValue());
}


/*****************************************************************************/
bool ViewInfoManager::Initialize(ViewInfoFunc viewInfoFunc)
{
   GetViewInfoFunc() = viewInfoFunc;
   return true;
}


/*****************************************************************************/
bool ViewInfoManager::IsInitialized()
{
   return GetViewInfoFunc() != NULL;
}


}
}
