/* ***************************************************************************************
* FILE:          ViewFactory.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ViewFactory.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_VIEW_FACTORY_H
#define HMIBASE_VIEW_FACTORY_H

#include <Courier/Visualization/ViewFactory.h>
#include <Courier/Visualization/ViewControllerFactory.h>

namespace hmibase {
namespace view {

struct ViewInfo;

/*****************************************************************************/
class ViewFactory : public Courier::ViewFactory
{
      typedef Courier::ViewFactory Base;

   public:
      /* overrides from Courier::ViewFactory */

      /* Called by ViewHandler to create a view (ViewScene2D, ViewScene3D, ViewContainer). */
      virtual Courier::View* Create(const FeatStd::Char* viewName) override;

      /* called by ViewHandler to destroy a view. */
      virtual void Destroy(Courier::View* view) override;

      /* Called by ViewHandler if method Create returns NULL in order to create a view scene which is managed by the view handler.
       * Managed by view handler means that it is deleted by the view handler without calling destroy from the view factory.
       */
      virtual Courier::ViewScene* CreateViewScene(bool is2D) override;

      /* Creates a view based on the information provided by ViewInfoManager.
       * override this if you want to perform additional initialization.
       */
      virtual Courier::View* Create(const ViewInfo& viewInfo);

      /* Managed by view handler means that it is deleted by the view handler without calling destroy from the view factory. */
      typedef Courier::ViewScene* (*CreateDefaultViewSceneFunc)(bool is2D, bool isManagedByViewHandler);

      /* Sets a custom factory method to create default view scenes. */
      static void SetCreateDefaultViewSceneFunc(CreateDefaultViewSceneFunc func);

      /* Creates a view scene; uses the custom factory method if it is set.
       * managed by view handler means that it is deleted by the view handler without calling destroy from the view factory.
       */
      virtual Courier::ViewScene* CreateDefaultViewScene(bool is2D, bool isManagedByViewHandler);

   protected:
      /* Custom method to create view scenes. */
      static CreateDefaultViewSceneFunc _createDefaultViewSceneFunc;
};


/*****************************************************************************/
class ViewControllerFactory : public Courier::ViewControllerFactory
{
      typedef Courier::ViewControllerFactory Base;

   public:
      virtual Courier::ViewController* Create(const FeatStd::Char* viewName) override;
      virtual Courier::ViewController* Create(const ViewInfo& viewInfo);
      virtual void Destroy(Courier::ViewController* viewController) override;
};


}
}


#endif
