/* ***************************************************************************************
* FILE:          ViewControllerBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ViewControllerBase.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __VIEW_CONTROLLER_BASE_H__
#define __VIEW_CONTROLLER_BASE_H__

#include "Courier/Visualization/ViewController.h"
#include "View/CGI/CgiExtensions/DataCompletionHandler.h"
#include "hmibase/util/Macros.h"

namespace hmibase {
namespace view {
class ViewControllerBase : public Courier::ViewController
{
   public:
      ViewControllerBase();
      ViewControllerBase(signed int priority);
      virtual ~ViewControllerBase();
      virtual void OnParentViewActivate(bool activate);
      virtual void OnParentViewLoad(bool load);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_HMI_FW)
      ON_COURIER_MESSAGE(TransitionMediatorOnDataCompleteMsg)
      ON_COURIER_MESSAGE(TimerExpiredMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_DELEGATE_TO_FKT(DispatchToMessageHandlers)
      COURIER_MSG_MAP_ENDS()
      DataCompletionHandler* getDataCompletionHandler();
      DataCompletionHandler _dataCompletionHandler;
      void setPrio(signed int prio)
      {
         _focuspriority = prio;
      }

      typedef void(*OnParentViewLoadFct)(bool load, Courier::View* view);
      static void SetOnParentViewLoadHook(OnParentViewLoadFct hook)
      {
         _onParentViewLoadHook = hook;
      }

      /************************************************************************/
      class MessageHandler
      {
         public:
            virtual ~MessageHandler() {}
            virtual bool OnMessage(ViewControllerBase& viewController, const Courier::Message& msg) = 0;
      };

      void RegisterMessageHandler(MessageHandler& handler);
      void UnregisterMessageHandler(MessageHandler& handler);

   private:
      bool onCourierMessage(const TransitionMediatorOnDataCompleteMsg& msg);
      bool onCourierMessage(const TimerExpiredMsg& msg);

      bool DispatchToMessageHandlers(const Courier::Message& msg);

      unsigned int getSurfaceId(const Candera::Surface* surface) const;
      signed int _focuspriority;

      typedef std::vector<MessageHandler*> MessageHandlersType;
      MessageHandlersType _messageHandlers;

      static OnParentViewLoadFct _onParentViewLoadHook;
};


}
}


HMIBASE_DEPRECATED_TYPE_ALIAS(ViewControllerBase, ::hmibase::view::ViewControllerBase);
#endif // __VIEW_CONTROLLER_BASE_H__
