/* ***************************************************************************************
* FILE:          ViewComponent.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ViewComponent.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "ViewComponent.h"
#include "MessageHandler.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_VIEW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ViewComponent.cpp.trc.h"
#endif

namespace hmibase {
namespace view {


/*****************************************************************************/
ViewComponent::MessageHandlersType ViewComponent::_messageHandlers;


/*****************************************************************************/
ViewComponent::ViewComponent()
{
}


/*****************************************************************************/
ViewComponent::~ViewComponent()
{
}


/*****************************************************************************/
void ViewComponent::registerMessageHandler(MessageHandler& handler)
{
   _messageHandlers.push_back(&handler);
}


/*****************************************************************************/
void ViewComponent::unregisterMessageHandler(MessageHandler& handler)
{
   MessageHandlersType::iterator it = std::find(_messageHandlers.begin(), _messageHandlers.end(), &handler);
   if (it != _messageHandlers.end())
   {
      _messageHandlers.erase(it);
   }
}


/*****************************************************************************/
bool ViewComponent::dispatchToMessageHandlers(const ::Courier::Message& msg)
{
   for (MessageHandlersType::iterator it = _messageHandlers.begin(); it != _messageHandlers.end(); ++it)
   {
      MessageHandler* handler = *it;
      if ((handler != NULL) && handler->onMessage(msg))
      {
         return true;
      }
   }
   return false;
}


/*****************************************************************************/
bool ViewComponent::OnMessage(const ::Courier::Message& msg)
{
   if (dispatchToMessageHandlers(msg))
   {
      return true;
   }

   return Base::OnMessage(msg);
}


}
}
