/* ***************************************************************************************
* FILE:          ViewAccessor.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ViewAccessor.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(_HMIBASE_VIEW_ACCESSOR_H_)
#define _HMIBASE_VIEW_ACCESSOR_H_

#include <Courier/Visualization/ViewId.h>

namespace Candera {
class GraphicDeviceUnit;
class Node;
class Node2D;
}


namespace Courier {
class View;
class ViewScene2D;
class ViewScene3D;
}


namespace hmibase {
namespace view {

/************************************************************************/
/* Provides support to manipulate 2D and 3D view scenes easily.
* - create, destroy, show and hide;
* - get camera or change camera render target;
* - get the render target associated to the texture of a node;
*/
class ViewAccessor
{
   public:
      /************************************************************************/
      ViewAccessor(Courier::View* view);
      ViewAccessor(const Courier::ViewId& viewId);
      ~ViewAccessor();

      /************************************************************************/
      Courier::View* GetView() const;
      const Courier::ViewId& GetViewId() const;

      /************************************************************************/
      bool CreateView();
      void DestroyView();
      void ShowView();
      void HideView();

      /************************************************************************/
      FeatStd::SizeType GetCameraCount() const;
      Candera::CanderaObject* GetCamera(FeatStd::SizeType index) const;

      static FeatStd::Optional<Candera::GraphicDeviceUnit*> SetCameraRT(Candera::CanderaObject* camera, Candera::GraphicDeviceUnit* gdu);

      /************************************************************************/
      Candera::GraphicDeviceUnit* FindTextureRT(const FeatStd::Char* nodeName) const;

      static Candera::Node2D* FindNode(Courier::ViewScene2D* viewScene, const FeatStd::Char* nodeName);
      static Candera::Node* FindNode(Courier::ViewScene3D* viewScene, const FeatStd::Char* nodeName);

      static Candera::GraphicDeviceUnit* GetTextureRT(Candera::Node2D* node);
      static Candera::GraphicDeviceUnit* GetTextureRT(Candera::Node* node);

   private:
      Courier::View* _view;
      Courier::ViewId _viewId;
};


}
}


#endif
